/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.metadata;

import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.internal.metadata.ProjectMetadataTransformer;
import com.linecorp.centraldogma.server.metadata.ProjectMetadata;
import com.linecorp.centraldogma.server.metadata.RepositoryMetadata;
import java.util.Map;
import java.util.function.BiFunction;

final class RepositoryMetadataTransformer
extends ProjectMetadataTransformer {
    RepositoryMetadataTransformer(String repoName, BiFunction<Revision, RepositoryMetadata, RepositoryMetadata> transformer) {
        super((headRevision, projectMetadata) -> {
            RepositoryMetadata repositoryMetadata = projectMetadata.repo(repoName);
            assert (repositoryMetadata.name().equals(repoName));
            RepositoryMetadata newRepositoryMetadata = (RepositoryMetadata)transformer.apply((Revision)headRevision, repositoryMetadata);
            return RepositoryMetadataTransformer.newProjectMetadata(projectMetadata, newRepositoryMetadata);
        });
    }

    private static ProjectMetadata newProjectMetadata(ProjectMetadata projectMetadata, RepositoryMetadata repositoryMetadata) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)projectMetadata.repos().size());
        for (Map.Entry<String, RepositoryMetadata> entry : projectMetadata.repos().entrySet()) {
            if (entry.getKey().equals(repositoryMetadata.name())) {
                builder.put((Object)entry.getKey(), (Object)repositoryMetadata);
                continue;
            }
            builder.put(entry);
        }
        ImmutableMap newRepos = builder.build();
        return new ProjectMetadata(projectMetadata.name(), (Map<String, RepositoryMetadata>)newRepos, projectMetadata.members(), projectMetadata.tokens(), projectMetadata.creation(), projectMetadata.removal());
    }
}

