/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.project;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.ProjectExistsException;
import com.linecorp.centraldogma.common.ProjectNotFoundException;
import com.linecorp.centraldogma.common.ProjectRole;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.internal.storage.repository.DefaultMetaRepository;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryCache;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CachingRepositoryManager;
import com.linecorp.centraldogma.server.internal.storage.repository.git.GitRepositoryManager;
import com.linecorp.centraldogma.server.metadata.Member;
import com.linecorp.centraldogma.server.metadata.ProjectMetadata;
import com.linecorp.centraldogma.server.metadata.RepositoryMetadata;
import com.linecorp.centraldogma.server.metadata.TokenRegistration;
import com.linecorp.centraldogma.server.metadata.UserAndTimestamp;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageManager;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.repository.MetaRepository;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import com.linecorp.centraldogma.server.storage.repository.RepositoryListener;
import com.linecorp.centraldogma.server.storage.repository.RepositoryManager;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProject
implements Project {
    private static final Logger logger = LoggerFactory.getLogger(DefaultProject.class);
    private final String name;
    private final long creationTimeMillis;
    private final Author author;
    final RepositoryManager repos;
    private volatile MetaRepository metaRepo;
    @Nullable
    private volatile Revision lastMetadataRevision;
    @Nullable
    private volatile ProjectMetadata projectMetadata;

    DefaultProject(File rootDir, Executor repositoryWorker, Executor purgeWorker, @Nullable RepositoryCache cache, EncryptionStorageManager encryptionStorageManager) {
        Objects.requireNonNull(rootDir, "rootDir");
        Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        Objects.requireNonNull(encryptionStorageManager, "encryptionStorageManager");
        if (!rootDir.exists()) {
            throw ProjectNotFoundException.of((String)rootDir.getName());
        }
        this.name = rootDir.getName();
        this.repos = this.newRepoManager(rootDir, repositoryWorker, purgeWorker, cache, encryptionStorageManager);
        if (!this.repos.exists("dogma")) {
            throw new IllegalStateException("The project does not have a dogma repository: " + rootDir);
        }
        boolean success = false;
        try {
            ProjectMetadata projectedMetadata = this.initialMetadata();
            if (projectedMetadata != null) {
                UserAndTimestamp creation = projectedMetadata.creation();
                this.creationTimeMillis = creation.timestampMillis();
                this.author = Author.ofEmail((String)creation.user());
                this.attachMetadataListener();
                this.resetMetaRepository();
            } else {
                this.creationTimeMillis = ((Repository)this.repos.get("dogma")).creationTimeMillis();
                this.author = ((Repository)this.repos.get("dogma")).author();
            }
            success = true;
        }
        catch (Exception e) {
            throw new CentralDogmaException("failed to initialize internal repositories of " + this.name, (Throwable)e);
        }
        finally {
            if (!success) {
                this.repos.close(() -> new CentralDogmaException("failed to initialize internal repositories of " + this.name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DefaultProject(@Nullable Project dogmaProject, File rootDir, Executor repositoryWorker, Executor purgeWorker, long creationTimeMillis, Author author, @Nullable RepositoryCache cache, EncryptionStorageManager encryptionStorageManager, boolean encryptDogmaRepo) {
        Repository dogmaProjectDogmaRepository;
        Entry entry;
        Objects.requireNonNull(rootDir, "rootDir");
        Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        Objects.requireNonNull(encryptionStorageManager, "encryptionStorageManager");
        if (rootDir.exists()) {
            throw ProjectExistsException.of((String)rootDir.getName());
        }
        this.name = rootDir.getName();
        this.repos = this.newRepoManager(rootDir, repositoryWorker, purgeWorker, cache, encryptionStorageManager);
        boolean useDogmaRepoAsMetaRepo = dogmaProject == null ? false : (entry = (dogmaProjectDogmaRepository = (Repository)dogmaProject.repos().get("dogma")).getOrNull(Revision.HEAD, Query.ofJson((String)"/meta-to-dogma-migration-job.json")).join()) != null;
        boolean success = false;
        try {
            this.createReservedRepos(creationTimeMillis, useDogmaRepoAsMetaRepo, encryptDogmaRepo);
            this.initializeMetadata(creationTimeMillis, author);
            this.creationTimeMillis = creationTimeMillis;
            this.author = author;
            this.attachMetadataListener();
            this.setMetaRepository(useDogmaRepoAsMetaRepo);
            success = true;
        }
        finally {
            if (!success) {
                this.repos.close(() -> new CentralDogmaException("failed to initialize internal repositories of " + this.name));
            }
        }
    }

    private RepositoryManager newRepoManager(File rootDir, Executor repositoryWorker, Executor purgeWorker, @Nullable RepositoryCache cache, EncryptionStorageManager encryptionStorageManager) {
        GitRepositoryManager gitRepos = new GitRepositoryManager(this, rootDir, repositoryWorker, purgeWorker, cache, encryptionStorageManager);
        return cache == null ? gitRepos : new CachingRepositoryManager((RepositoryManager)gitRepos, cache);
    }

    private void createReservedRepos(long creationTimeMillis, boolean useDogmaRepoAsMetaRepo, boolean encryptDogmaRepo) {
        if (!this.repos.exists("dogma")) {
            try {
                Repository dogmaRepository = (Repository)this.repos.create("dogma", creationTimeMillis, Author.SYSTEM, encryptDogmaRepo);
                if (useDogmaRepoAsMetaRepo) {
                    dogmaRepository.commit(Revision.HEAD, creationTimeMillis, Author.SYSTEM, "Add /meta-to-dogma-migrated.json file to dogma repository", "", Markup.PLAINTEXT, Change.ofJsonUpsert((String)"/meta-to-dogma-migrated.json", (String)"{}")).join();
                }
            }
            catch (RepositoryExistsException repositoryExistsException) {
                // empty catch block
            }
        }
        if (!useDogmaRepoAsMetaRepo && !this.repos.exists("meta")) {
            try {
                this.repos.create("meta", creationTimeMillis, Author.SYSTEM, encryptDogmaRepo);
            }
            catch (RepositoryExistsException repositoryExistsException) {
                // empty catch block
            }
        }
    }

    @Override
    @Nullable
    public ProjectMetadata metadata() {
        return this.projectMetadata;
    }

    private void initializeMetadata(long creationTimeMillis, Author author) {
        Revision headRev;
        if (this.name.equals("dogma")) {
            return;
        }
        Repository dogmaRepo = (Repository)this.repos.get("dogma");
        if (!dogmaRepo.exists(headRev = dogmaRepo.normalizeNow(Revision.HEAD), "/metadata.json").join().booleanValue()) {
            ImmutableMap tokens;
            ImmutableMap members;
            logger.info("Initializing metadata of project: {}", (Object)this.name);
            UserAndTimestamp userAndTimestamp = UserAndTimestamp.of(author);
            if (author.isToken()) {
                members = ImmutableMap.of();
                TokenRegistration tokenRegistration = new TokenRegistration(author.name(), ProjectRole.OWNER, userAndTimestamp);
                tokens = ImmutableMap.of((Object)tokenRegistration.id(), (Object)tokenRegistration);
            } else {
                Member member = new Member(author, ProjectRole.OWNER, userAndTimestamp);
                members = ImmutableMap.of((Object)member.id(), (Object)member);
                tokens = ImmutableMap.of();
            }
            ProjectMetadata metadata = new ProjectMetadata(this.name, (Map<String, RepositoryMetadata>)ImmutableMap.of(), (Map<String, Member>)members, (Map<String, TokenRegistration>)tokens, userAndTimestamp, null);
            CommitResult result = dogmaRepo.commit(headRev, creationTimeMillis, Author.SYSTEM, "Initialize metadata", "", Markup.PLAINTEXT, Change.ofJsonUpsert((String)"/metadata.json", (JsonNode)Jackson.valueToTree((Object)metadata))).join();
            this.lastMetadataRevision = result.revision();
            this.projectMetadata = metadata;
        }
    }

    @Nullable
    private ProjectMetadata initialMetadata() throws ExecutionException, InterruptedException, JsonProcessingException {
        if (this.name.equals("dogma")) {
            return null;
        }
        Entry metadata = ((Repository)this.repos.get("dogma")).get(Revision.HEAD, Query.ofJson((String)"/metadata.json")).get();
        ProjectMetadata projectMetadata = (ProjectMetadata)Jackson.treeToValue((TreeNode)((TreeNode)metadata.content()), ProjectMetadata.class);
        this.lastMetadataRevision = metadata.revision();
        this.projectMetadata = projectMetadata;
        return projectMetadata;
    }

    private void attachMetadataListener() {
        if (this.name.equals("dogma")) {
            return;
        }
        Repository dogmaRepo = (Repository)this.repos.get("dogma");
        dogmaRepo.addListener(RepositoryListener.of(Query.ofJson((String)"/metadata.json"), entry -> {
            if (entry == null) {
                logger.warn("{} file is missing in {}/{}", new Object[]{"/metadata.json", this.name, "dogma"});
                return;
            }
            Revision lastRevision = entry.revision();
            Revision lastMetadataRevision = this.lastMetadataRevision;
            assert (lastMetadataRevision != null);
            if (lastRevision.compareTo(lastMetadataRevision) <= 0) {
                return;
            }
            try {
                ProjectMetadata projectMetadata = (ProjectMetadata)Jackson.treeToValue((TreeNode)((TreeNode)entry.content()), ProjectMetadata.class);
                this.lastMetadataRevision = lastRevision;
                this.projectMetadata = projectMetadata;
            }
            catch (JsonParseException | JsonMappingException e) {
                logger.warn("Invalid {} file in {}/{}", new Object[]{"/metadata.json", this.name, "dogma", e});
            }
        }));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public long creationTimeMillis() {
        return this.creationTimeMillis;
    }

    @Override
    public Author author() {
        return this.author;
    }

    @Override
    public MetaRepository resetMetaRepository() {
        Entry entry;
        Repository repository = (Repository)this.repos.get("dogma");
        CompletableFuture future = repository.getOrNull(Revision.HEAD, Query.ofJson((String)"/meta-to-dogma-migrated.json"));
        try {
            entry = future.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to get the migration entry in 10 seconds. ", e);
        }
        return this.setMetaRepository(entry != null);
    }

    private MetaRepository setMetaRepository(boolean useDogmaRepoAsMetaRepo) {
        String repoName = useDogmaRepoAsMetaRepo ? "dogma" : "meta";
        DefaultMetaRepository metaRepo = new DefaultMetaRepository((Repository)this.repos.get(repoName));
        this.metaRepo = metaRepo;
        return metaRepo;
    }

    @Override
    public MetaRepository metaRepo() {
        Preconditions.checkState((!this.name.equals("dogma") ? 1 : 0) != 0, (String)"metaRepo() is not available for %s project", (Object)"dogma");
        return this.metaRepo;
    }

    @Override
    public RepositoryManager repos() {
        return this.repos;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("author", (Object)this.author).add("repos", (Object)this.repos).toString();
    }
}

