/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.internal.storage.MigratingMetaToDogmaRepositoryService;
import com.linecorp.centraldogma.server.plugin.Plugin;
import com.linecorp.centraldogma.server.plugin.PluginContext;
import com.linecorp.centraldogma.server.plugin.PluginTarget;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigratingMetaToDogmaRepositoryServicePlugin
implements Plugin {
    private static final Logger logger = LoggerFactory.getLogger(MigratingMetaToDogmaRepositoryServicePlugin.class);
    @Nullable
    private MigratingMetaToDogmaRepositoryService migratingMetaToDogmaRepositoryService;

    @Override
    public PluginTarget target(CentralDogmaConfig config) {
        return PluginTarget.LEADER_ONLY;
    }

    @Override
    public synchronized CompletionStage<Void> start(PluginContext context) {
        Objects.requireNonNull(context, "context");
        try {
            MigratingMetaToDogmaRepositoryService migratingMetaToDogmaRepositoryService;
            this.migratingMetaToDogmaRepositoryService = migratingMetaToDogmaRepositoryService = new MigratingMetaToDogmaRepositoryService(context.projectManager(), context.commandExecutor(), context.internalProjectInitializer());
            if (migratingMetaToDogmaRepositoryService.hasMigrationLog()) {
                logger.debug("Meta repositories of all projects have already been migrated.");
                return UnmodifiableFuture.completedFuture(null);
            }
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("migrating-meta-to-dogma-repository-worker", true));
            executor.schedule(() -> {
                try {
                    migratingMetaToDogmaRepositoryService.migrate();
                }
                catch (Exception e) {
                    logger.error("Failed to migrate meta repository to dogma repository:", (Throwable)e);
                }
            }, 60L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("Failed to migrate meta repository to dogma repository:", (Throwable)e);
        }
        return UnmodifiableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletionStage<Void> stop(PluginContext context) {
        MigratingMetaToDogmaRepositoryService migratingMetaToDogmaRepositoryService = this.migratingMetaToDogmaRepositoryService;
        if (migratingMetaToDogmaRepositoryService != null) {
            block7: {
                try {
                    if (migratingMetaToDogmaRepositoryService.tryStop()) break block7;
                    logger.info("Waiting for the migration of meta repositories to dogma repositories to finish up to 10 seconds...");
                    for (int i = 0; i < 10; ++i) {
                        try {
                            if (!migratingMetaToDogmaRepositoryService.tryStop()) {
                                Thread.sleep(1000L);
                                continue;
                            }
                            break;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn("Failed to check if the migration of meta repositories to dogma repositories  is done:", (Throwable)e);
                }
            }
            this.migratingMetaToDogmaRepositoryService = null;
        }
        return UnmodifiableFuture.completedFuture(null);
    }

    @Override
    public boolean isEnabled(CentralDogmaConfig config) {
        return true;
    }

    @Override
    public Class<?> configType() {
        return this.getClass();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("target", (Object)PluginTarget.LEADER_ONLY).toString();
    }
}

