/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.auth;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.auth.BasicToken;
import com.linecorp.armeria.common.auth.OAuth2Token;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.auth.AuthTokenExtractors;
import com.linecorp.armeria.server.auth.Authorizer;
import io.netty.util.AttributeKey;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;

public abstract class AbstractAuthorizer
implements Authorizer<HttpRequest> {
    private static final AttributeKey<String> TOKEN_KEY = AttributeKey.valueOf(AbstractAuthorizer.class, (String)"TOKEN_KEY");
    private static final String BASIC_USERNAME = "dogma";

    public CompletionStage<Boolean> authorize(ServiceRequestContext ctx, HttpRequest req) {
        String token = AbstractAuthorizer.extractToken(ctx, req);
        if (token == null) {
            return UnmodifiableFuture.completedFuture((Object)false);
        }
        return this.authorize(ctx, req, token);
    }

    protected abstract CompletionStage<Boolean> authorize(ServiceRequestContext var1, HttpRequest var2, String var3);

    @Nullable
    private static String extractToken(ServiceRequestContext ctx, HttpRequest req) {
        BasicToken basicToken;
        String token = (String)ctx.attr(TOKEN_KEY);
        if (token != null) {
            return token;
        }
        RequestHeaders headers = req.headers();
        String authorization = headers.get((CharSequence)HttpHeaderNames.AUTHORIZATION);
        if (authorization == null) {
            return null;
        }
        if (authorization.regionMatches(true, 0, "Bearer", 0, 6)) {
            OAuth2Token oAuth2Token = (OAuth2Token)AuthTokenExtractors.oAuth2().apply(headers);
            if (oAuth2Token != null) {
                token = oAuth2Token.accessToken();
            }
        } else if (authorization.regionMatches(true, 0, "Basic", 0, 5) && (basicToken = (BasicToken)AuthTokenExtractors.basic().apply(headers)) != null && BASIC_USERNAME.equals(basicToken.username())) {
            token = basicToken.password();
        }
        if (token != null) {
            ctx.setAttr(TOKEN_KEY, (Object)token);
        }
        return token;
    }
}

