/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.plugin;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.server.plugin.PluginConfig;
import java.io.IOException;

public final class PluginConfigDeserializer
extends StdDeserializer<PluginConfig> {
    private static final long serialVersionUID = 1L;

    public PluginConfigDeserializer() {
        super(PluginConfig.class);
    }

    public PluginConfig deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode jsonNode = (JsonNode)jp.readValueAsTree();
        JsonNode type = jsonNode.get("type");
        if (type == null || type.asText() == null) {
            ctxt.reportInputMismatch(PluginConfig.class, "plugin config should have a type.", new Object[0]);
            throw new Error();
        }
        String typeText = type.asText();
        try {
            Class<?> clazz = Class.forName(typeText);
            if (!PluginConfig.class.isAssignableFrom(clazz)) {
                ctxt.reportInputMismatch(PluginConfig.class, typeText + " is not a subtype of " + PluginConfig.class.getSimpleName(), new Object[0]);
                throw new Error();
            }
            assert (jsonNode instanceof ObjectNode);
            ObjectNode objectNode = (ObjectNode)jsonNode;
            objectNode.remove("type");
            return (PluginConfig)Jackson.treeToValue((TreeNode)objectNode, clazz);
        }
        catch (ClassNotFoundException e) {
            ctxt.reportInputMismatch(PluginConfig.class, typeText + " is not found.", new Object[0]);
            throw new Error();
        }
    }
}

