/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Objects;
import com.linecorp.centraldogma.server.metadata.Identifiable;
import com.linecorp.centraldogma.server.metadata.UserAndTimestamp;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class Token
implements Identifiable {
    private final String appId;
    @Nullable
    private final String secret;
    private final boolean isSystemAdmin;
    private final boolean allowGuestAccess;
    private final UserAndTimestamp creation;
    @Nullable
    private final UserAndTimestamp deactivation;
    @Nullable
    private final UserAndTimestamp deletion;

    Token(String appId, String secret, boolean isSystemAdmin, boolean allowGuestAccess, UserAndTimestamp creation) {
        this(appId, secret, null, isSystemAdmin, allowGuestAccess, creation, null, null);
    }

    @JsonCreator
    public Token(@JsonProperty(value="appId") String appId, @JsonProperty(value="secret") String secret, @JsonProperty(value="admin") @Nullable Boolean isAdmin, @JsonProperty(value="systemAdmin") @Nullable Boolean isSystemAdmin, @JsonProperty(value="allowGuestAccess") @Nullable Boolean allowGuestAccess, @JsonProperty(value="creation") UserAndTimestamp creation, @JsonProperty(value="deactivation") @Nullable UserAndTimestamp deactivation, @JsonProperty(value="deletion") @Nullable UserAndTimestamp deletion) {
        assert (isAdmin != null || isSystemAdmin != null);
        this.appId = Util.validateFileName((String)appId, (String)"appId");
        this.secret = Util.validateFileName((String)secret, (String)"secret");
        this.isSystemAdmin = isSystemAdmin != null ? isSystemAdmin : isAdmin;
        this.allowGuestAccess = (Boolean)MoreObjects.firstNonNull((Object)allowGuestAccess, (Object)true);
        this.creation = java.util.Objects.requireNonNull(creation, "creation");
        this.deactivation = deactivation;
        this.deletion = deletion;
    }

    private Token(String appId, boolean isSystemAdmin, boolean allowGuestAccess, UserAndTimestamp creation, @Nullable UserAndTimestamp deactivation, @Nullable UserAndTimestamp deletion) {
        this.appId = Util.validateFileName((String)appId, (String)"appId");
        this.isSystemAdmin = isSystemAdmin;
        this.allowGuestAccess = allowGuestAccess;
        this.creation = java.util.Objects.requireNonNull(creation, "creation");
        this.deactivation = deactivation;
        this.deletion = deletion;
        this.secret = null;
    }

    @Override
    public String id() {
        return this.appId;
    }

    @JsonProperty
    public String appId() {
        return this.appId;
    }

    @Nullable
    @JsonProperty
    public String secret() {
        return this.secret;
    }

    @JsonProperty
    public boolean isSystemAdmin() {
        return this.isSystemAdmin;
    }

    @JsonProperty
    public boolean allowGuestAccess() {
        return this.allowGuestAccess;
    }

    @JsonProperty
    public UserAndTimestamp creation() {
        return this.creation;
    }

    @Nullable
    @JsonProperty
    public UserAndTimestamp deactivation() {
        return this.deactivation;
    }

    @Nullable
    @JsonProperty
    public UserAndTimestamp deletion() {
        return this.deletion;
    }

    @JsonIgnore
    public boolean isActive() {
        return this.deactivation == null && this.deletion == null;
    }

    @JsonIgnore
    public boolean isDeleted() {
        return this.deletion != null;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.appId, this.secret, this.isSystemAdmin, this.allowGuestAccess, this.creation, this.deactivation, this.deletion});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token that = (Token)o;
        return this.appId.equals(that.appId) && Objects.equal((Object)this.secret, (Object)that.secret) && this.isSystemAdmin == that.isSystemAdmin && this.allowGuestAccess == that.allowGuestAccess && this.creation.equals(that.creation) && Objects.equal((Object)this.deactivation, (Object)that.deactivation) && Objects.equal((Object)this.deletion, (Object)that.deletion);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("appId", (Object)this.appId()).add("isSystemAdmin", this.isSystemAdmin()).add("allowGuestAccess", this.allowGuestAccess()).add("creation", (Object)this.creation()).add("deactivation", (Object)this.deactivation()).add("deletion", (Object)this.deletion()).toString();
    }

    public Token withoutSecret() {
        return new Token(this.appId(), this.isSystemAdmin(), this.allowGuestAccess(), this.creation(), this.deactivation(), this.deletion());
    }

    public Token withSystemAdmin(boolean isSystemAdmin) {
        if (isSystemAdmin == this.isSystemAdmin()) {
            return this;
        }
        String secret = this.secret();
        assert (secret != null);
        return new Token(this.appId(), secret, null, isSystemAdmin, this.allowGuestAccess(), this.creation(), this.deactivation(), this.deletion());
    }
}

