/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.ProjectRole;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.metadata.Identifiable;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.metadata.UserAndTimestamp;
import com.linecorp.centraldogma.server.storage.repository.HasWeight;
import java.util.Objects;

public class Member
implements Identifiable,
HasWeight {
    private final String login;
    private final ProjectRole role;
    private final UserAndTimestamp creation;

    public Member(User user, ProjectRole role, UserAndTimestamp creation) {
        this(Objects.requireNonNull(user, "user").id(), role, creation);
    }

    public Member(Author author, ProjectRole role, UserAndTimestamp creation) {
        this(Objects.requireNonNull(author, "author").email(), role, creation);
    }

    @JsonCreator
    public Member(@JsonProperty(value="login") String login, @JsonProperty(value="role") ProjectRole role, @JsonProperty(value="creation") UserAndTimestamp creation) {
        this.login = Util.toEmailAddress((String)login, (String)"login");
        this.role = Objects.requireNonNull(role, "role");
        this.creation = Objects.requireNonNull(creation, "creation");
    }

    @Override
    public String id() {
        return this.login;
    }

    @JsonProperty
    public String login() {
        return this.login;
    }

    @JsonProperty
    public ProjectRole role() {
        return this.role;
    }

    @Override
    public int weight() {
        return this.login.length() + this.role.name().length();
    }

    @JsonProperty
    public UserAndTimestamp creation() {
        return this.creation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Member)) {
            return false;
        }
        Member that = (Member)o;
        return this.login.equals(that.login) && this.role == that.role && this.creation.equals(that.creation);
    }

    public int hashCode() {
        return Objects.hash(this.login, this.role, this.creation);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("login", (Object)this.login()).add("role", (Object)this.role()).add("creation", (Object)this.creation()).toString();
    }
}

