/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb;

import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb.RocksDbRefUpdate;
import com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb.RocksDbRepository;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;

final class RocksDbRefDatabase
extends RefDatabase {
    private final RocksDbRepository repo;

    RocksDbRefDatabase(RocksDbRepository repo) {
        this.repo = repo;
    }

    public void create() throws IOException {
    }

    public void close() {
    }

    public boolean isNameConflicting(String name) throws IOException {
        assert (name.equals("HEAD") || name.equals("refs/heads/master")) : name;
        return false;
    }

    public RefUpdate newUpdate(String name, boolean detach) throws IOException {
        assert (!detach);
        Ref ref = this.repo.encryptionGitStorage().readRef(name);
        if (ref == null) {
            ref = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, name, null);
        }
        return new RocksDbRefUpdate(ref, this, this.repo);
    }

    public RefRename newRename(String fromName, String toName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Ref exactRef(String name) throws IOException {
        return this.repo.encryptionGitStorage().readRef(name);
    }

    public Map<String, Ref> getRefs(String prefix) throws IOException {
        return ImmutableMap.of();
    }

    public List<Ref> getAdditionalRefs() throws IOException {
        return ImmutableList.of();
    }

    public Ref peel(Ref ref) throws IOException {
        return ref;
    }
}

