/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.credential;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.CredentialUtil;
import com.linecorp.centraldogma.internal.shaded.guava.base.CharMatcher;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Splitter;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.credential.Credential;
import com.linecorp.centraldogma.server.credential.CredentialType;
import com.linecorp.centraldogma.server.internal.credential.AbstractCredential;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SshKeyCredential
extends AbstractCredential {
    private static final Logger logger = LoggerFactory.getLogger(SshKeyCredential.class);
    private static final Splitter NEWLINE_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\n\r")).omitEmptyStrings().trimResults();
    private static final int PUBLIC_KEY_PREVIEW_LEN = 40;
    private final String username;
    private final String publicKey;
    private final String privateKey;
    @Nullable
    private final String passphrase;

    @JsonCreator
    public SshKeyCredential(@JsonProperty(value="name") @Nullable String name, @JsonProperty(value="username") String username, @JsonProperty(value="publicKey") String publicKey, @JsonProperty(value="privateKey") String privateKey, @JsonProperty(value="passphrase") @Nullable String passphrase) {
        super(name, CredentialType.SSH_KEY);
        this.username = CredentialUtil.requireNonEmpty((String)username, (String)"username");
        this.publicKey = CredentialUtil.requireNonEmpty((String)publicKey, (String)"publicKey");
        this.privateKey = CredentialUtil.requireNonEmpty((String)privateKey, (String)"privateKey");
        this.passphrase = passphrase;
    }

    @JsonProperty(value="username")
    public String username() {
        return this.username;
    }

    @JsonProperty(value="publicKey")
    public String publicKey() {
        return this.publicKey;
    }

    public List<String> privateKey() {
        String converted;
        try {
            converted = CentralDogmaConfig.convertValue(this.privateKey, "credentials.privateKey");
        }
        catch (Throwable t) {
            logger.debug("Failed to convert the key of the credential. username: {}, id: {}", new Object[]{this.username, this.id(), t});
            converted = this.privateKey;
        }
        assert (converted != null);
        return ImmutableList.copyOf((Collection)NEWLINE_SPLITTER.splitToList((CharSequence)converted));
    }

    @JsonProperty(value="privateKey")
    public String rawPrivateKey() {
        return this.privateKey;
    }

    @Nullable
    public String passphrase() {
        try {
            return CentralDogmaConfig.convertValue(this.passphrase, "credentials.passphrase");
        }
        catch (Throwable t) {
            logger.debug("Failed to convert the passphrase of the credential. username: {}, id: {}", new Object[]{this.username, this.id(), t});
            return this.passphrase;
        }
    }

    @JsonProperty(value="passphrase")
    @Nullable
    public String rawPassphrase() {
        return this.passphrase;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SshKeyCredential)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SshKeyCredential that = (SshKeyCredential)o;
        return this.username.equals(that.username) && Objects.equals(this.publicKey, that.publicKey) && Objects.equals(this.privateKey, that.privateKey) && Objects.equals(this.passphrase, that.passphrase);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.username, this.publicKey, this.privateKey, this.passphrase);
    }

    @Override
    void addProperties(MoreObjects.ToStringHelper helper) {
        helper.add("username", (Object)this.username).add("publicKey", (Object)SshKeyCredential.publicKeyPreview(this.publicKey));
    }

    public static String publicKeyPreview(String publicKey) {
        if (publicKey.length() > 40) {
            return publicKey.substring(0, 40) + "..";
        }
        return publicKey;
    }

    @Override
    public Credential withoutSecret() {
        return new SshKeyCredential(this.name(), this.username(), this.publicKey(), "****", "****");
    }

    @Override
    public Credential withName(String credentialName) {
        Objects.requireNonNull(credentialName, "credentialName");
        return new SshKeyCredential(credentialName, this.username, this.publicKey, this.privateKey, this.passphrase);
    }
}

