/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.RepositoryRole;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import com.linecorp.centraldogma.server.metadata.RepositoryMetadata;
import com.linecorp.centraldogma.server.metadata.Roles;
import com.linecorp.centraldogma.server.metadata.UserAndTimestamp;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageException;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageManager;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public final class RepositoryServiceUtil {
    public static CompletableFuture<Revision> createRepository(CommandExecutor commandExecutor, MetadataService mds, Author author, String projectName, String repoName, boolean encrypt, @Nullable EncryptionStorageManager encryptionStorageManager) {
        ImmutableMap tokens;
        ImmutableMap users;
        if (author.isToken()) {
            users = ImmutableMap.of();
            tokens = ImmutableMap.of((Object)author.name(), (Object)RepositoryRole.ADMIN);
        } else {
            users = ImmutableMap.of((Object)author.email(), (Object)RepositoryRole.ADMIN);
            tokens = ImmutableMap.of();
        }
        Roles roles = new Roles(RepositoryMetadata.DEFAULT_PROJECT_ROLES, (Map<String, RepositoryRole>)users, (Map<String, RepositoryRole>)tokens);
        RepositoryMetadata repositoryMetadata = RepositoryMetadata.of(repoName, roles, UserAndTimestamp.of(author));
        if (!encrypt) {
            return commandExecutor.execute(Command.createRepository(author, projectName, repoName)).thenCompose(unused -> mds.addRepo(author, projectName, repoName, repositoryMetadata));
        }
        assert (encryptionStorageManager != null);
        return ((CompletableFuture)((CompletableFuture)encryptionStorageManager.generateWdek().thenCompose(wdek -> commandExecutor.execute(Command.createRepository(author, projectName, repoName, wdek)))).thenCompose(unused -> mds.addRepo(author, projectName, repoName, repositoryMetadata))).exceptionally(cause -> {
            if (cause instanceof EncryptionStorageException) {
                throw (EncryptionStorageException)cause;
            }
            throw new EncryptionStorageException("Failed to create encrypted repository " + projectName + '/' + repoName, (Throwable)cause);
        });
    }

    public static CompletableFuture<Revision> removeRepository(CommandExecutor commandExecutor, MetadataService mds, Author author, String projectName, String repoName) {
        return commandExecutor.execute(Command.removeRepository(author, projectName, repoName)).thenCompose(unused -> mds.removeRepo(author, projectName, repoName));
    }

    private RepositoryServiceUtil() {
    }
}

