/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.command;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.server.command.CommandType;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.command.ContentTransformer;
import com.linecorp.centraldogma.server.command.NormalizableCommit;
import com.linecorp.centraldogma.server.command.PushAsIsCommand;
import com.linecorp.centraldogma.server.command.RepositoryCommand;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TransformCommand
extends RepositoryCommand<CommitResult>
implements NormalizableCommit {
    private final Revision baseRevision;
    private final String summary;
    private final String detail;
    private final Markup markup;
    private final ContentTransformer<?> transformer;

    public static TransformCommand of(@Nullable Long timestamp, @Nullable Author author, String projectName, String repositoryName, Revision baseRevision, String summary, String detail, Markup markup, ContentTransformer<?> transformer) {
        return new TransformCommand(timestamp, author, projectName, repositoryName, baseRevision, summary, detail, markup, transformer);
    }

    private TransformCommand(@Nullable Long timestamp, @Nullable Author author, String projectName, String repositoryName, Revision baseRevision, String summary, String detail, Markup markup, ContentTransformer<?> transformer) {
        super(CommandType.TRANSFORM, timestamp, author, projectName, repositoryName);
        this.baseRevision = baseRevision;
        this.summary = summary;
        this.detail = detail;
        this.markup = markup;
        this.transformer = transformer;
    }

    @JsonProperty
    public Revision baseRevision() {
        return this.baseRevision;
    }

    @JsonProperty
    public String summary() {
        return this.summary;
    }

    @JsonProperty
    public String detail() {
        return this.detail;
    }

    @JsonProperty
    public Markup markup() {
        return this.markup;
    }

    public ContentTransformer<?> transformer() {
        return this.transformer;
    }

    @Override
    public PushAsIsCommand asIs(CommitResult commitResult) {
        Objects.requireNonNull(commitResult, "commitResult");
        return new PushAsIsCommand(this.timestamp(), this.author(), this.projectName(), this.repositoryName(), commitResult.revision().backward(1), this.summary(), this.detail(), this.markup(), commitResult.changes());
    }
}

