/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.auth;

import com.linecorp.centraldogma.server.internal.storage.AesGcmSivCipher;
import java.nio.charset.StandardCharsets;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;

public final class SessionKey {
    private static final byte[] SIGNING_KEY_INFO = "session-signing-key".getBytes(StandardCharsets.UTF_8);
    private static final byte[] ENCRYPTION_KEY_INFO = "session-encryption-key".getBytes(StandardCharsets.UTF_8);
    private final SecretKey signingKey;
    private final SecretKey encryptionKey;
    private final int version;

    public static SessionKey of(byte[] masterKey, byte[] salt, int version) {
        HKDFBytesGenerator hkdfBytesGenerator = new HKDFBytesGenerator((Digest)new SHA256Digest());
        byte[] signingKeyBytes = new byte[32];
        hkdfBytesGenerator.init((DerivationParameters)new HKDFParameters(masterKey, salt, SIGNING_KEY_INFO));
        hkdfBytesGenerator.generateBytes(signingKeyBytes, 0, 32);
        byte[] encryptionKeyBytes = new byte[32];
        hkdfBytesGenerator.init((DerivationParameters)new HKDFParameters(masterKey, salt, ENCRYPTION_KEY_INFO));
        hkdfBytesGenerator.generateBytes(encryptionKeyBytes, 0, 32);
        SecretKeySpec finalSigningKey = new SecretKeySpec(signingKeyBytes, "HmacSHA256");
        SecretKeySpec finalEncryptionKey = AesGcmSivCipher.aesSecretKey(encryptionKeyBytes);
        return new SessionKey(finalSigningKey, finalEncryptionKey, version);
    }

    private SessionKey(SecretKey signingKey, SecretKey encryptionKey, int version) {
        this.signingKey = signingKey;
        this.encryptionKey = encryptionKey;
        this.version = version;
    }

    public SecretKey signingKey() {
        return this.signingKey;
    }

    public SecretKey encryptionKey() {
        return this.encryptionKey;
    }

    public int version() {
        return this.version;
    }
}

