/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import java.util.List;
import java.util.Objects;

public final class ZoneConfig {
    private final String currentZone;
    private final List<String> allZones;

    @JsonCreator
    public ZoneConfig(@JsonProperty(value="currentZone") String currentZone, @JsonProperty(value="allZones") List<String> allZones) {
        Objects.requireNonNull(currentZone, "currentZone");
        Objects.requireNonNull(allZones, "allZones");
        this.currentZone = CentralDogmaConfig.convertValue(currentZone, "zone.currentZone");
        this.allZones = allZones;
        Preconditions.checkArgument((boolean)allZones.contains(currentZone), (String)"The current zone: %s, (expected: one of %s)", (Object)currentZone, allZones);
    }

    @JsonProperty(value="currentZone")
    public String currentZone() {
        return this.currentZone;
    }

    @JsonProperty(value="allZones")
    public List<String> allZones() {
        return this.allZones;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ZoneConfig)) {
            return false;
        }
        ZoneConfig that = (ZoneConfig)o;
        return this.currentZone.equals(that.currentZone) && this.allZones.equals(that.allZones);
    }

    public int hashCode() {
        return Objects.hash(this.currentZone, this.allZones);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("currentZone", (Object)this.currentZone).add("allZones", this.allZones).toString();
    }
}

