/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.auth.AuthFailureHandler;
import com.linecorp.centraldogma.common.AuthorizationException;
import com.linecorp.centraldogma.common.ShuttingDownException;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CentralDogmaAuthFailureHandler
implements AuthFailureHandler {
    private static final Logger logger = LoggerFactory.getLogger(CentralDogmaAuthFailureHandler.class);
    private static final AuthorizationException AUTHORIZATION_EXCEPTION = new AuthorizationException("", false);
    private static final ResponseHeaders UNAUTHORIZED_HEADERS = ResponseHeaders.builder((HttpStatus)HttpStatus.UNAUTHORIZED).add((CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, "Bearer realm=\"Central Dogma\", charset=\"UTF-8\"").add((CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, "Basic realm=\"Central Dogma\", charset=\"UTF-8\"").build();

    CentralDogmaAuthFailureHandler() {
    }

    public HttpResponse authFailed(HttpService delegate, ServiceRequestContext ctx, HttpRequest req, @Nullable Throwable cause) throws Exception {
        if (cause != null) {
            if (!(cause instanceof ShuttingDownException)) {
                logger.warn("Unexpected exception during authorization:", cause);
            }
            return HttpApiUtil.newResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, cause);
        }
        if ("/api/v0/users/me".equals(ctx.path())) {
            return HttpApiUtil.newResponse(ctx, HttpStatus.UNAUTHORIZED, (Throwable)AUTHORIZATION_EXCEPTION);
        }
        return HttpApiUtil.newResponse(ctx, UNAUTHORIZED_HEADERS, (Throwable)AUTHORIZATION_EXCEPTION);
    }
}

