/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.mirror;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.server.plugin.AbstractPluginConfig;
import javax.annotation.Nullable;

public final class MirroringServicePluginConfig
extends AbstractPluginConfig {
    public static final MirroringServicePluginConfig INSTANCE = new MirroringServicePluginConfig(true, null, null, null, false);
    static final int DEFAULT_NUM_MIRRORING_THREADS = 16;
    static final int DEFAULT_MAX_NUM_FILES_PER_MIRROR = 8192;
    static final long DEFAULT_MAX_NUM_BYTES_PER_MIRROR = 0x2000000L;
    private final int numMirroringThreads;
    private final int maxNumFilesPerMirror;
    private final long maxNumBytesPerMirror;
    private final boolean zonePinned;
    private final boolean runMigration;

    public MirroringServicePluginConfig(boolean enabled) {
        this(enabled, null, null, null, false);
    }

    @JsonCreator
    public MirroringServicePluginConfig(@JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="numMirroringThreads") @Nullable Integer numMirroringThreads, @JsonProperty(value="maxNumFilesPerMirror") @Nullable Integer maxNumFilesPerMirror, @JsonProperty(value="maxNumBytesPerMirror") @Nullable Long maxNumBytesPerMirror, @JsonProperty(value="zonePinned") boolean zonePinned) {
        super(enabled);
        this.numMirroringThreads = (Integer)MoreObjects.firstNonNull((Object)numMirroringThreads, (Object)16);
        Preconditions.checkArgument((this.numMirroringThreads > 0 ? 1 : 0) != 0, (String)"numMirroringThreads: %s (expected: > 0)", (int)this.numMirroringThreads);
        this.maxNumFilesPerMirror = (Integer)MoreObjects.firstNonNull((Object)maxNumFilesPerMirror, (Object)8192);
        Preconditions.checkArgument((this.maxNumFilesPerMirror > 0 ? 1 : 0) != 0, (String)"maxNumFilesPerMirror: %s (expected: > 0)", (int)this.maxNumFilesPerMirror);
        this.maxNumBytesPerMirror = (Long)MoreObjects.firstNonNull((Object)maxNumBytesPerMirror, (Object)0x2000000L);
        Preconditions.checkArgument((this.maxNumBytesPerMirror > 0L ? 1 : 0) != 0, (String)"maxNumBytesPerMirror: %s (expected: > 0)", (long)this.maxNumBytesPerMirror);
        this.zonePinned = zonePinned;
        this.runMigration = true;
    }

    @Deprecated
    public MirroringServicePluginConfig(@Nullable boolean enabled, @Nullable Integer numMirroringThreads, @Nullable Integer maxNumFilesPerMirror, @Nullable Long maxNumBytesPerMirror, boolean zonePinned, boolean runMigration) {
        super(enabled);
        this.numMirroringThreads = (Integer)MoreObjects.firstNonNull((Object)numMirroringThreads, (Object)16);
        this.maxNumFilesPerMirror = (Integer)MoreObjects.firstNonNull((Object)maxNumFilesPerMirror, (Object)8192);
        this.maxNumBytesPerMirror = (Long)MoreObjects.firstNonNull((Object)maxNumBytesPerMirror, (Object)0x2000000L);
        this.zonePinned = zonePinned;
        this.runMigration = runMigration;
    }

    @JsonProperty
    public int numMirroringThreads() {
        return this.numMirroringThreads;
    }

    @JsonProperty
    public int maxNumFilesPerMirror() {
        return this.maxNumFilesPerMirror;
    }

    @JsonProperty
    public long maxNumBytesPerMirror() {
        return this.maxNumBytesPerMirror;
    }

    @JsonProperty(value="zonePinned")
    public boolean zonePinned() {
        return this.zonePinned;
    }

    @Deprecated
    public boolean runMigration() {
        return this.runMigration;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numMirroringThreads", this.numMirroringThreads).add("maxNumFilesPerMirror", this.maxNumFilesPerMirror).add("maxNumBytesPerMirror", this.maxNumBytesPerMirror).add("zonePinned", this.zonePinned).toString();
    }
}

