/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.mirror;

import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.mirror.Mirror;
import com.linecorp.centraldogma.server.storage.project.Project;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nullable;

public final class MirrorTask {
    private final Mirror mirror;
    private final User triggeredBy;
    private final Instant triggeredTime;
    @Nullable
    private final String currentZone;
    private final boolean scheduled;

    public MirrorTask(Mirror mirror, User triggeredBy, Instant triggeredTime, @Nullable String currentZone, boolean scheduled) {
        this.mirror = mirror;
        this.triggeredTime = triggeredTime;
        this.triggeredBy = triggeredBy;
        this.currentZone = currentZone;
        this.scheduled = scheduled;
    }

    public Mirror mirror() {
        return this.mirror;
    }

    public Project project() {
        return this.mirror.localRepo().parent();
    }

    public User triggeredBy() {
        return this.triggeredBy;
    }

    public Instant triggeredTime() {
        return this.triggeredTime;
    }

    @Nullable
    public String currentZone() {
        return this.currentZone;
    }

    public boolean scheduled() {
        return this.scheduled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MirrorTask)) {
            return false;
        }
        MirrorTask that = (MirrorTask)o;
        return this.mirror.equals(that.mirror) && this.triggeredTime.equals(that.triggeredTime) && this.triggeredBy.equals(that.triggeredBy) && this.scheduled == that.scheduled;
    }

    public int hashCode() {
        return Objects.hash(this.mirror, this.triggeredTime, this.triggeredBy, this.scheduled);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mirror", (Object)this.mirror).add("triggeredTime", (Object)this.triggeredTime).add("triggeredBy", (Object)this.triggeredBy).add("scheduled", this.scheduled).toString();
    }
}

