/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb;

import com.linecorp.centraldogma.server.internal.storage.AesGcmSivCipher;
import com.linecorp.centraldogma.server.internal.storage.encryption.EncryptionUtil;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class GitObjectMetadata {
    private final int keyVersion;
    private final byte[] nonce;
    private final int type;
    private final byte[] objectWdek;

    public static GitObjectMetadata of(int keyVersion, byte[] nonce, int type, byte[] objectWdek) {
        return new GitObjectMetadata(keyVersion, nonce, type, objectWdek);
    }

    public static GitObjectMetadata fromBytes(byte[] metadata) {
        int expectedLength = 68;
        if (metadata.length != 68) {
            throw new IllegalArgumentException("Invalid metadata length: expected 68, got " + metadata.length);
        }
        byte[] nonce = new byte[12];
        System.arraycopy(metadata, 4, nonce, 0, 12);
        int wdekLength = metadata.length - 20;
        byte[] objectWdek = new byte[wdekLength];
        System.arraycopy(metadata, 20, objectWdek, 0, wdekLength);
        return new GitObjectMetadata(EncryptionUtil.getInt(metadata, 0), nonce, EncryptionUtil.getInt(metadata, 16), objectWdek);
    }

    private GitObjectMetadata(int keyVersion, byte[] nonce, int type, byte[] objectWdek) {
        this.keyVersion = keyVersion;
        this.nonce = nonce;
        this.type = type;
        this.objectWdek = objectWdek;
    }

    public int keyVersion() {
        return this.keyVersion;
    }

    public byte[] nonce() {
        return this.nonce;
    }

    public int type() {
        return this.type;
    }

    public byte[] objectWdek() {
        return this.objectWdek;
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[20 + this.objectWdek.length];
        int index = 0;
        EncryptionUtil.putInt(bytes, index, this.keyVersion);
        System.arraycopy(this.nonce, 0, bytes, index += 4, 12);
        EncryptionUtil.putInt(bytes, index += 12, this.type);
        System.arraycopy(this.objectWdek, 0, bytes, index += 4, this.objectWdek.length);
        return bytes;
    }

    public SecretKeySpec objectDek(SecretKey dek) throws Exception {
        byte[] objectDekRaw = AesGcmSivCipher.decrypt(dek, this.nonce, this.objectWdek);
        return AesGcmSivCipher.aesSecretKey(objectDekRaw);
    }
}

