/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git;

import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.server.internal.storage.repository.git.LruMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public final class PathPatternFilter
extends TreeFilter {
    private static final Pattern SPLIT = Pattern.compile("\\s*,\\s*");
    private static final ThreadLocal<LruMap<String, PathPatternFilter>> filterCache = LruMap.newThreadLocal(512);
    private static final ThreadLocal<LruMap<String, Pattern>> regexCache = LruMap.newThreadLocal(1024);
    private final Pattern[] pathPatterns;
    private final String pathPattern;

    public static PathPatternFilter of(String pathPattern) {
        LruMap<String, PathPatternFilter> map = filterCache.get();
        PathPatternFilter f = (PathPatternFilter)((Object)map.get(pathPattern));
        if (f == null) {
            f = new PathPatternFilter(pathPattern);
            map.put(pathPattern, f);
        }
        return f;
    }

    private PathPatternFilter(String pathPattern) {
        Util.validatePathPattern((String)pathPattern, (String)"pathPattern");
        String[] pathPatterns = SPLIT.split(pathPattern);
        StringBuilder pathPatternBuf = new StringBuilder(pathPattern.length());
        ArrayList<Pattern> compiledPathPatterns = new ArrayList<Pattern>(pathPatterns.length);
        boolean matchAll = false;
        for (String p : pathPatterns) {
            if ("/**".equals(p)) {
                matchAll = true;
                break;
            }
            if (p.isEmpty()) continue;
            String normalized = PathPatternFilter.normalize(p);
            compiledPathPatterns.add(PathPatternFilter.compile(normalized));
            pathPatternBuf.append(normalized).append(',');
        }
        if (matchAll) {
            this.pathPatterns = null;
            this.pathPattern = "/**";
        } else {
            if (compiledPathPatterns.isEmpty()) {
                throw new IllegalArgumentException("pathPattern is empty.");
            }
            this.pathPatterns = compiledPathPatterns.toArray(new Pattern[compiledPathPatterns.size()]);
            this.pathPattern = pathPatternBuf.substring(0, pathPatternBuf.length() - 1);
        }
    }

    private static String normalize(String p) {
        String normalized = p.charAt(0) != '/' ? "/**/" + p : p;
        return normalized;
    }

    private static Pattern compile(String pathPattern) {
        if (pathPattern.isEmpty()) {
            throw new IllegalArgumentException("contains an empty path pattern");
        }
        Map map = regexCache.get();
        Pattern compiled = (Pattern)map.get(pathPattern);
        if (compiled == null) {
            compiled = PathPatternFilter.compileUncached(pathPattern);
            map.put(pathPattern, compiled);
        }
        return compiled;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Pattern compileUncached(String pathPattern) {
        if (pathPattern.charAt(0) != '/') {
            pathPattern = "/**/" + pathPattern;
        }
        int pathPatternLen = pathPattern.length();
        StringBuilder buf = new StringBuilder(pathPatternLen).append('^');
        int asterisks = 0;
        int beforeAsterisk = 47;
        block11: for (int i = 1; i < pathPatternLen; ++i) {
            char c = pathPattern.charAt(i);
            if (c == '*') {
                if (++asterisks <= 2) continue;
                throw new IllegalArgumentException("contains a path pattern with invalid wildcard characters: " + pathPattern + " (only * and ** are allowed)");
            }
            switch (asterisks) {
                case 1: {
                    if (beforeAsterisk == 47 && c == '/') {
                        buf.append("[^/]+");
                        break;
                    }
                    buf.append("[^/]*");
                    break;
                }
                case 2: {
                    if (beforeAsterisk == 47 && c == '/') {
                        buf.append("(?:.+/)?");
                        asterisks = 0;
                        beforeAsterisk = c;
                        continue block11;
                    }
                    buf.append(".*");
                }
            }
            asterisks = 0;
            beforeAsterisk = c;
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    buf.append('\\');
                    buf.append(c);
                    continue block11;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        switch (asterisks) {
            case 1: {
                if (beforeAsterisk == 47) {
                    buf.append("[^/]+");
                    return Pattern.compile(buf.append('$').toString());
                }
                buf.append("[^/]*");
                return Pattern.compile(buf.append('$').toString());
            }
            case 2: {
                buf.append(".*");
                return Pattern.compile(buf.append('$').toString());
            }
        }
        return Pattern.compile(buf.append('$').toString());
    }

    public boolean include(TreeWalk walker) {
        if (walker.isSubtree()) {
            return true;
        }
        return this.matches(walker);
    }

    public boolean matches(TreeWalk walker) {
        if (this.pathPatterns == null) {
            return true;
        }
        for (Pattern p : this.pathPatterns) {
            if (!p.matcher(walker.getPathString()).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean matches(String path) {
        if (this.pathPatterns == null) {
            return true;
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        for (Pattern p : this.pathPatterns) {
            if (!p.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean matchesAll() {
        return this.pathPatterns == null;
    }

    public boolean shouldBeRecursive() {
        return true;
    }

    public PathPatternFilter clone() {
        return this;
    }

    public int hashCode() {
        return this.pathPattern.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PathPatternFilter)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.pathPattern.equals(((PathPatternFilter)((Object)obj)).pathPattern);
    }

    public String toString() {
        return this.pathPattern;
    }
}

