/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.server.internal.JGitUtil;
import com.linecorp.centraldogma.server.internal.storage.DirectoryBasedStorageManager;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryCache;
import com.linecorp.centraldogma.server.internal.storage.repository.git.CommitUtil;
import com.linecorp.centraldogma.server.internal.storage.repository.git.DefaultCommitIdDatabase;
import com.linecorp.centraldogma.server.internal.storage.repository.git.GitRepository;
import com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb.EncryptionGitStorage;
import com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb.RocksDbCommitIdDatabase;
import com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb.RocksDbRepository;
import com.linecorp.centraldogma.server.storage.StorageException;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageManager;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import com.linecorp.centraldogma.server.storage.repository.RepositoryManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GitRepositoryManager
extends DirectoryBasedStorageManager<Repository>
implements RepositoryManager {
    private static final Logger logger = LoggerFactory.getLogger(GitRepositoryManager.class);
    private static final String ENCRYPTED_REPO_PLACEHOLDER_FILE = ".encryption-repo-placeholder";
    private final Project parent;
    private final Executor repositoryWorker;
    @Nullable
    private final RepositoryCache cache;

    public GitRepositoryManager(Project parent, File rootDir, Executor repositoryWorker, Executor purgeWorker, @Nullable RepositoryCache cache, EncryptionStorageManager encryptionStorageManager) {
        super(rootDir, Repository.class, purgeWorker, encryptionStorageManager);
        this.parent = Objects.requireNonNull(parent, "parent");
        this.repositoryWorker = Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        this.cache = cache;
        this.init();
    }

    @Override
    public Project parent() {
        return this.parent;
    }

    private String projectRepositoryName(String name) {
        return this.parent.name() + '/' + name;
    }

    @Override
    public void migrateToEncryptedRepository(String repositoryName) {
        GitRepository encryptedRepository;
        logger.info("Starting to migrate the repository '{}' to an encrypted repository.", (Object)this.projectRepositoryName(repositoryName));
        long startTime = System.nanoTime();
        Repository oldRepository = (Repository)this.get(repositoryName);
        EncryptionStorageManager encryptionStorageManager = this.encryptionStorageManager();
        try {
            encryptedRepository = GitRepositoryManager.createEncryptedRepository(this.parent, oldRepository.repoDir(), oldRepository.author(), oldRepository.creationTimeMillis(), this.repositoryWorker, this.cache, encryptionStorageManager);
        }
        catch (Throwable t) {
            throw new StorageException("failed to create the repository while migrating. repositoryName: " + this.projectRepositoryName(repositoryName), t);
        }
        Revision headRevision = oldRepository.normalizeNow(Revision.HEAD);
        Revision baseRevision = null;
        try {
            for (int i = 2; i <= headRevision.major(); ++i) {
                baseRevision = new Revision(i - 1);
                Revision revision = new Revision(i);
                CompletableFuture<List<Commit>> historyFuture = oldRepository.history(revision, revision, "/**");
                CompletableFuture<Map<String, Change<?>>> changesFuture = oldRepository.diff(baseRevision, revision, "/**");
                CompletableFuture.allOf(historyFuture, changesFuture).join();
                List<Commit> commits = historyFuture.join();
                assert (commits.size() == 1);
                Commit commit = commits.get(0);
                encryptedRepository.commit(baseRevision, commit.when(), commit.author(), commit.summary(), changesFuture.join().values()).join();
            }
        }
        catch (Throwable t) {
            encryptedRepository.internalClose();
            encryptionStorageManager.deleteRepositoryData(this.parent.name(), repositoryName);
            throw new StorageException("failed to migrate the contents of the repository '" + this.projectRepositoryName(repositoryName) + "' to an encrypted repository. baseRevision: " + baseRevision, t);
        }
        try {
            Files.createFile(Paths.get(oldRepository.repoDir().getPath(), ENCRYPTED_REPO_PLACEHOLDER_FILE), new FileAttribute[0]);
        }
        catch (IOException e) {
            encryptedRepository.internalClose();
            encryptionStorageManager.deleteRepositoryData(this.parent.name(), repositoryName);
            throw new StorageException("failed to create the encrypted repository placeholder file at: " + oldRepository.repoDir(), e);
        }
        if (!this.replaceChild(repositoryName, oldRepository, encryptedRepository)) {
            encryptedRepository.internalClose();
            encryptionStorageManager.deleteRepositoryData(this.parent.name(), repositoryName);
            try {
                Files.delete(Paths.get(oldRepository.repoDir().getPath(), ENCRYPTED_REPO_PLACEHOLDER_FILE));
            }
            catch (IOException e) {
                logger.warn("Failed to delete the encrypted repository placeholder file at: {}", (Object)oldRepository.repoDir(), (Object)e);
            }
            throw new StorageException("failed to replace the old repository with the encrypted repository. repositoryName: " + this.projectRepositoryName(repositoryName));
        }
        logger.info("Migrated the repository '{}' to an encrypted repository in {} seconds.", (Object)this.projectRepositoryName(repositoryName), (Object)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startTime));
        ((GitRepository)oldRepository).close(() -> new CentralDogmaException(this.projectRepositoryName(repositoryName) + " is migrated to an encrypted repository. Try again."));
    }

    @Override
    protected Repository openChild(File childDir) throws Exception {
        Objects.requireNonNull(childDir, "childDir");
        if (GitRepositoryManager.isEncryptedRepository(childDir)) {
            return GitRepositoryManager.openEncryptionRepository(this.parent, childDir, this.repositoryWorker, this.cache, this.encryptionStorageManager());
        }
        return GitRepositoryManager.openFileRepository(this.parent, childDir, this.repositoryWorker, this.cache);
    }

    public static boolean isEncryptedRepository(File dir) {
        return Files.exists(dir.toPath().resolve(ENCRYPTED_REPO_PLACEHOLDER_FILE), new LinkOption[0]);
    }

    @VisibleForTesting
    static Repository openEncryptionRepository(Project parent, File repoDir, Executor repositoryWorker, @Nullable RepositoryCache cache, EncryptionStorageManager encryptionStorageManager) {
        EncryptionGitStorage encryptionGitStorage = new EncryptionGitStorage(parent.name(), repoDir.getName(), encryptionStorageManager);
        RocksDbRepository rocksDbRepository = new RocksDbRepository(encryptionGitStorage);
        Revision headRevision = GitRepositoryManager.uncachedHeadRevision(rocksDbRepository, parent, repoDir);
        RocksDbCommitIdDatabase commitIdDatabase = new RocksDbCommitIdDatabase(encryptionGitStorage, headRevision);
        return new GitRepository(parent, repoDir, repositoryWorker, cache, rocksDbRepository, commitIdDatabase, headRevision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static GitRepository openFileRepository(Project parent, File repoDir, Executor repositoryWorker, @Nullable RepositoryCache cache) {
        GitRepository gitRepository;
        block9: {
            org.eclipse.jgit.lib.Repository jGitRepository;
            try {
                jGitRepository = ((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setGitDir(repoDir)).setBare()).build();
                if (!GitRepositoryManager.exist(repoDir)) {
                    throw new RepositoryNotFoundException(repoDir.toString());
                }
                int formatVersion = jGitRepository.getConfig().getInt("core", null, "repositoryformatversion", 0);
                if (formatVersion != 1) {
                    throw new StorageException("unsupported repository format version: " + formatVersion + " (expected: " + 1 + ')');
                }
                JGitUtil.applyDefaultsAndSave(jGitRepository.getConfig());
            }
            catch (IOException e) {
                throw new StorageException("failed to open a repository at: " + repoDir, e);
            }
            DefaultCommitIdDatabase commitIdDatabase = null;
            boolean success = false;
            try {
                Revision headRevision = GitRepositoryManager.uncachedHeadRevision(jGitRepository, parent, repoDir);
                commitIdDatabase = new DefaultCommitIdDatabase(jGitRepository);
                if (!headRevision.equals((Object)commitIdDatabase.headRevision())) {
                    commitIdDatabase.rebuild(jGitRepository);
                    assert (headRevision.equals((Object)commitIdDatabase.headRevision()));
                }
                GitRepository gitRepository2 = new GitRepository(parent, repoDir, repositoryWorker, cache, jGitRepository, commitIdDatabase, headRevision);
                success = true;
                gitRepository = gitRepository2;
                if (success) break block9;
            }
            catch (Throwable throwable) {
                if (!success) {
                    GitRepository.closeRepository(commitIdDatabase, jGitRepository);
                }
                throw throwable;
            }
            GitRepository.closeRepository(commitIdDatabase, jGitRepository);
        }
        return gitRepository;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Revision uncachedHeadRevision(org.eclipse.jgit.lib.Repository jGitRepository, Project parent, File repoDir) {
        try (RevWalk revWalk = GitRepository.newRevWalk(jGitRepository.newObjectReader());){
            ObjectId headRevisionId = jGitRepository.resolve("refs/heads/master");
            if (headRevisionId == null) throw new StorageException("failed to determine the HEAD: " + parent.name() + '/' + repoDir.getName());
            RevCommit revCommit = revWalk.parseCommit((AnyObjectId)headRevisionId);
            Revision revision = CommitUtil.extractRevision(revCommit.getFullMessage());
            return revision;
        }
        catch (CentralDogmaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException("failed to get the current revision", e);
        }
    }

    @Override
    protected Repository createChild(File childDir, Author author, long creationTimeMillis, boolean encrypt) throws Exception {
        Objects.requireNonNull(childDir, "childDir");
        Objects.requireNonNull(author, "author");
        if (encrypt) {
            return GitRepositoryManager.createEncryptionRepository(this.parent, childDir, author, creationTimeMillis, this.repositoryWorker, this.cache, this.encryptionStorageManager());
        }
        return GitRepositoryManager.createFileRepository(this.parent, childDir, author, creationTimeMillis, this.repositoryWorker, this.cache);
    }

    @VisibleForTesting
    static GitRepository createEncryptionRepository(Project parent, File repoDir, Author author, long creationTimeMillis, Executor repositoryWorker, @Nullable RepositoryCache cache, EncryptionStorageManager encryptionStorageManager) throws IOException {
        if (!repoDir.mkdirs()) {
            throw new StorageException("failed to create a repository at: " + repoDir + " (exists already)");
        }
        try {
            Files.createFile(Paths.get(repoDir.getPath(), ENCRYPTED_REPO_PLACEHOLDER_FILE), new FileAttribute[0]);
            return GitRepositoryManager.createEncryptedRepository(parent, repoDir, author, creationTimeMillis, repositoryWorker, cache, encryptionStorageManager);
        }
        catch (Throwable t) {
            GitRepository.deleteCruft(repoDir);
            throw new StorageException("failed to create a repository at: " + repoDir, t);
        }
    }

    private static GitRepository createEncryptedRepository(Project parent, File repoDir, Author author, long creationTimeMillis, Executor repositoryWorker, @Nullable RepositoryCache cache, EncryptionStorageManager encryptionStorageManager) throws IOException {
        EncryptionGitStorage encryptionGitStorage = new EncryptionGitStorage(parent.name(), repoDir.getName(), encryptionStorageManager);
        RocksDbRepository rocksDbRepository = new RocksDbRepository(encryptionGitStorage);
        RefUpdate head = rocksDbRepository.updateRef("HEAD");
        head.disableRefLog();
        head.link("refs/heads/master");
        RocksDbCommitIdDatabase commitIdDatabase = new RocksDbCommitIdDatabase(encryptionGitStorage, null);
        return new GitRepository(parent, repoDir, repositoryWorker, creationTimeMillis, author, cache, rocksDbRepository, commitIdDatabase);
    }

    @VisibleForTesting
    static GitRepository createFileRepository(Project parent, File repoDir, Author author, long creationTimeMillis, Executor repositoryWorker, @Nullable RepositoryCache cache) throws IOException {
        org.eclipse.jgit.lib.Repository jGitRepository = null;
        DefaultCommitIdDatabase commitIdDatabase = null;
        try {
            RepositoryBuilder repositoryBuilder = (RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setGitDir(repoDir)).setBare();
            try (org.eclipse.jgit.lib.Repository initRepo = repositoryBuilder.build();){
                if (GitRepositoryManager.exist(repoDir)) {
                    throw new StorageException("failed to create a repository at: " + repoDir + " (exists already)");
                }
                initRepo.create(true);
                JGitUtil.applyDefaultsAndSave(initRepo.getConfig());
            }
            jGitRepository = ((RepositoryBuilder)new RepositoryBuilder().setGitDir(repoDir)).build();
            RefUpdate head = jGitRepository.updateRef("HEAD");
            head.disableRefLog();
            head.link("refs/heads/master");
            commitIdDatabase = new DefaultCommitIdDatabase(jGitRepository);
            return new GitRepository(parent, repoDir, repositoryWorker, creationTimeMillis, author, cache, jGitRepository, commitIdDatabase);
        }
        catch (Throwable t) {
            GitRepository.closeRepository(commitIdDatabase, jGitRepository);
            GitRepository.deleteCruft(repoDir);
            throw new StorageException("failed to create a repository at: " + repoDir, t);
        }
    }

    private static boolean exist(File repoDir) {
        try {
            RepositoryBuilder repositoryBuilder = (RepositoryBuilder)new RepositoryBuilder().setGitDir(repoDir);
            org.eclipse.jgit.lib.Repository repository = repositoryBuilder.build();
            if (repository.getConfig() instanceof FileBasedConfig) {
                return ((FileBasedConfig)repository.getConfig()).getFile().exists();
            }
            return repository.getDirectory().exists();
        }
        catch (IOException e) {
            throw new StorageException("failed to check if repository exists at " + repoDir, e);
        }
    }

    @Override
    protected void closeChild(File childDir, Repository child, Supplier<CentralDogmaException> failureCauseSupplier) {
        ((GitRepository)child).close(failureCauseSupplier);
    }

    @Override
    protected CentralDogmaException newStorageExistsException(String name) {
        return new RepositoryExistsException(this.parent().name() + '/' + name);
    }

    @Override
    protected CentralDogmaException newStorageNotFoundException(String name) {
        return new RepositoryNotFoundException(this.parent().name() + '/' + name);
    }

    @Override
    protected void deletePurged(File file) {
        String repoName = GitRepositoryManager.removeInterfixAndPurgedSuffix(file.getName());
        logger.info("Deleting a purged repository: {} ..", (Object)repoName);
        if (GitRepositoryManager.isEncryptedRepository(file)) {
            this.encryptionStorageManager().deleteRepositoryData(this.parent.name(), repoName);
        }
        try {
            Util.deleteFileTree((File)file);
            logger.info("Deleted a purged repository: {}.", (Object)repoName);
        }
        catch (IOException e) {
            logger.warn("Failed to delete a purged repository: {}", (Object)repoName, (Object)e);
        }
    }

    public static String removeInterfixAndPurgedSuffix(String name) {
        assert (name.endsWith(".purged"));
        name = name.substring(0, name.length() - ".purged".length());
        int index = name.lastIndexOf(46);
        assert (index > 0);
        return name.substring(0, index);
    }
}

