/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git;

import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryCache;
import com.linecorp.centraldogma.server.internal.storage.repository.git.CacheableObjectLoaderCall;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.io.IOException;
import javax.annotation.Nullable;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;

final class CachingTreeObjectReader
extends ObjectReader.Filter {
    private final Repository repository;
    private final ObjectReader delegate;
    @Nullable
    private final RepositoryCache cache;

    CachingTreeObjectReader(Repository repository, ObjectReader delegate, @Nullable RepositoryCache cache) {
        this.repository = repository;
        this.delegate = delegate;
        this.cache = cache;
    }

    protected ObjectReader delegate() {
        return this.delegate;
    }

    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws IOException {
        if (2 != typeHint || this.cache == null) {
            return this.delegate.open(objectId, typeHint);
        }
        CacheableObjectLoaderCall key = new CacheableObjectLoaderCall(this.repository, this.delegate, (AnyObjectId)objectId.toObjectId());
        return this.cache.get(key).join();
    }
}

