/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.server.storage.StorageException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;

abstract class AbstractChangesApplier {
    private static final byte[] EMPTY_BYTE = new byte[0];

    AbstractChangesApplier() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    int apply(Repository jGitRepository, Revision headRevision, @Nullable ObjectId baseTreeId, DirCache dirCache) {
        try (ObjectInserter inserter = jGitRepository.newObjectInserter();){
            int n;
            block16: {
                ObjectReader reader = jGitRepository.newObjectReader();
                try {
                    if (baseTreeId != null) {
                        DirCacheBuilder builder = dirCache.builder();
                        builder.addTree(EMPTY_BYTE, 0, reader, (AnyObjectId)baseTreeId);
                        builder.finish();
                    }
                    n = this.doApply(headRevision, dirCache, reader, inserter);
                    if (reader == null) break block16;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return n;
        }
        catch (CentralDogmaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException("failed to apply changes on revision: " + headRevision.major(), e);
        }
    }

    abstract int doApply(Revision var1, DirCache var2, ObjectReader var3, ObjectInserter var4) throws IOException;

    static void applyPathEdit(DirCache dirCache, DirCacheEditor.PathEdit edit) {
        DirCacheEditor e = dirCache.editor();
        e.add(edit);
        e.finish();
    }

    static final class CopyOldEntry
    extends DirCacheEditor.PathEdit {
        private final DirCacheEntry oldEntry;

        CopyOldEntry(String entryPath, DirCacheEntry oldEntry) {
            super(entryPath);
            this.oldEntry = oldEntry;
        }

        public void apply(DirCacheEntry ent) {
            ent.setFileMode(this.oldEntry.getFileMode());
            ent.setObjectId((AnyObjectId)this.oldEntry.getObjectId());
        }
    }

    static final class InsertText
    extends DirCacheEditor.PathEdit {
        private final ObjectInserter inserter;
        private final String text;

        InsertText(String entryPath, ObjectInserter inserter, String text) {
            super(entryPath);
            this.inserter = inserter;
            this.text = text;
        }

        public void apply(DirCacheEntry ent) {
            try {
                ent.setObjectId((AnyObjectId)this.inserter.insert(3, this.text.getBytes(StandardCharsets.UTF_8)));
                ent.setFileMode(FileMode.REGULAR_FILE);
            }
            catch (IOException e) {
                throw new StorageException("failed to create a new text blob", e);
            }
        }
    }

    static final class InsertJson
    extends DirCacheEditor.PathEdit {
        private final ObjectInserter inserter;
        private final JsonNode jsonNode;

        InsertJson(String entryPath, ObjectInserter inserter, JsonNode jsonNode) {
            super(entryPath);
            this.inserter = inserter;
            this.jsonNode = jsonNode;
        }

        public void apply(DirCacheEntry ent) {
            try {
                ent.setObjectId((AnyObjectId)this.inserter.insert(3, Jackson.writeValueAsBytes((Object)this.jsonNode)));
                ent.setFileMode(FileMode.REGULAR_FILE);
            }
            catch (IOException e) {
                throw new StorageException("failed to create a new JSON blob", e);
            }
        }
    }
}

