/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.Cron;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.CronType;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.definition.CronDefinitionBuilder;
import com.linecorp.centraldogma.internal.shaded.cronutils.parser.CronParser;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Streams;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryUri;
import com.linecorp.centraldogma.server.mirror.MirrorDirection;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class MirrorConfig {
    public static final String DEFAULT_SCHEDULE = "0 * * * * ?";
    public static final CronParser CRON_PARSER = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    private final String id;
    private final boolean enabled;
    private final MirrorDirection direction;
    private final String localRepo;
    private final String localPath;
    private final URI remoteUri;
    @Nullable
    private final String gitignore;
    private final String credentialName;
    @Nullable
    private final Cron schedule;
    @Nullable
    private final String zone;

    @JsonCreator
    public MirrorConfig(@JsonProperty(value="id") String id, @JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="schedule") @Nullable String schedule, @JsonProperty(value="direction", required=true) MirrorDirection direction, @JsonProperty(value="localRepo", required=true) String localRepo, @JsonProperty(value="localPath") @Nullable String localPath, @JsonProperty(value="remoteUri", required=true) URI remoteUri, @JsonProperty(value="gitignore") @Nullable Object gitignore, @JsonProperty(value="credentialId") @Nullable String credentialId, @JsonProperty(value="credentialName") @Nullable String credentialName, @JsonProperty(value="zone") @Nullable String zone) {
        this(id, enabled, schedule != null ? CRON_PARSER.parse(schedule) : null, direction, localRepo, localPath, remoteUri, gitignore, Objects.requireNonNull((String)MoreObjects.firstNonNull((Object)credentialName, (Object)credentialId), "credentialName"), zone);
    }

    /*
     * Unable to fully structure code
     */
    private MirrorConfig(String id, @Nullable Boolean enabled, @Nullable Cron schedule, MirrorDirection direction, String localRepo, @Nullable String localPath, URI remoteUri, @Nullable Object gitignore, String credentialName, @Nullable String zone) {
        super();
        this.id = Objects.requireNonNull(id, "id");
        this.enabled = (Boolean)MoreObjects.firstNonNull((Object)enabled, (Object)true);
        this.schedule = schedule;
        this.direction = Objects.requireNonNull(direction, "direction");
        this.localRepo = Objects.requireNonNull(localRepo, "localRepo");
        this.localPath = (String)MoreObjects.firstNonNull((Object)localPath, (Object)"/");
        this.remoteUri = Objects.requireNonNull(remoteUri, "remoteUri");
        suffix = remoteUri.getScheme().equals("dogma") != false ? "dogma" : "git";
        RepositoryUri.parse(remoteUri, suffix);
        if (gitignore == null) ** GOTO lbl24
        if (!(gitignore instanceof Iterable)) ** GOTO lbl-1000
        if (Streams.stream((Iterable)((Iterable)gitignore)).allMatch((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Ljava/lang/Object;)Z)(String.class))) {
            this.gitignore = String.join((CharSequence)"\n", (Iterable)gitignore);
        } else if (gitignore instanceof String) {
            this.gitignore = (String)gitignore;
        } else {
            throw new IllegalArgumentException("gitignore: " + gitignore + " (expected: either a string or an array of strings)");
lbl24:
            // 1 sources

            this.gitignore = null;
        }
        this.credentialName = Objects.requireNonNull(credentialName, "credentialName");
        this.zone = zone;
    }

    public MirrorConfig withCredentialName(String credentialName) {
        return new MirrorConfig(this.id, this.enabled, this.schedule, this.direction, this.localRepo, this.localPath, this.remoteUri, this.gitignore, credentialName, this.zone);
    }

    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    @JsonProperty(value="direction")
    public MirrorDirection direction() {
        return this.direction;
    }

    @JsonProperty(value="localRepo")
    public String localRepo() {
        return this.localRepo;
    }

    @JsonProperty(value="localPath")
    public String localPath() {
        return this.localPath;
    }

    @JsonProperty(value="remoteUri")
    public String remoteUri() {
        return this.remoteUri.toString();
    }

    URI rawRemoteUri() {
        return this.remoteUri;
    }

    @JsonProperty(value="gitignore")
    @Nullable
    public String gitignore() {
        return this.gitignore;
    }

    @JsonProperty(value="credentialName")
    public String credentialName() {
        return this.credentialName;
    }

    @Nullable
    @JsonProperty(value="schedule")
    public String schedule() {
        if (this.schedule != null) {
            return this.schedule.asString();
        }
        return null;
    }

    @Nullable
    Cron cronSchedule() {
        return this.schedule;
    }

    @Nullable
    @JsonProperty(value="zone")
    public String zone() {
        return this.zone;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("enabled", this.enabled).add("direction", (Object)this.direction).add("localRepo", (Object)this.localRepo).add("localPath", (Object)this.localPath).add("remoteUri", (Object)this.remoteUri).add("gitignore", (Object)this.gitignore).add("credentialName", (Object)this.credentialName).add("schedule", (Object)this.schedule).add("zone", (Object)this.zone).toString();
    }
}

