/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.RepositoryStatus;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.base.Stopwatch;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import com.linecorp.centraldogma.server.storage.project.InternalProjectInitializer;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigratingMetaToDogmaRepositoryService {
    private static final Logger logger = LoggerFactory.getLogger(MigratingMetaToDogmaRepositoryService.class);
    public static final String META_TO_DOGMA_MIGRATION_JOB = "/meta-to-dogma-migration-job.json";
    public static final String META_TO_DOGMA_MIGRATED = "/meta-to-dogma-migrated.json";
    private final ProjectManager projectManager;
    private final CommandExecutor commandExecutor;
    private final MetadataService metadataService;
    private State state = State.NOT_STARTED;
    private final ReentrantShortLock lock = new ReentrantShortLock();

    MigratingMetaToDogmaRepositoryService(ProjectManager projectManager, CommandExecutor commandExecutor, InternalProjectInitializer internalProjectInitializer) {
        this.projectManager = projectManager;
        this.commandExecutor = commandExecutor;
        this.metadataService = new MetadataService(projectManager, commandExecutor, internalProjectInitializer);
    }

    boolean hasMigrationLog() throws ExecutionException, InterruptedException {
        Project internalProj = (Project)this.projectManager.get("dogma");
        Repository repository = (Repository)internalProj.repos().get("dogma");
        Entry entry = repository.getOrNull(Revision.HEAD, Query.ofJson((String)META_TO_DOGMA_MIGRATION_JOB)).get();
        return entry != null;
    }

    void migrate() throws Exception {
        this.lock.lock();
        try {
            if (this.state == State.STARTED) {
                logger.info("Migration job is already running. Skipping the migration.");
                return;
            }
            if (this.state == State.STOPPED) {
                logger.info("Migration job has been stopped. Skipping the migration.");
                return;
            }
            this.state = State.STARTED;
        }
        finally {
            this.lock.unlock();
        }
        logger.info("Starting to migrate meta repository to dogma repository of all projects ...");
        Stopwatch stopwatch = Stopwatch.createStarted();
        int numMigratedProjects = this.migrate0(true);
        this.logMigrationJob(numMigratedProjects);
        logger.info("Migrating meta repository to dogma repository of {} projects has been completed.(took: {} ms.)", (Object)numMigratedProjects, (Object)stopwatch.elapsed().toMillis());
        logger.info("Starting to migrate meta repository to dogma repository again to check if there are any projects that are created during migration ...");
        numMigratedProjects = this.migrate0(false);
        logger.info("Migrating meta repository to dogma repository of {} projects has been completed.", (Object)numMigratedProjects);
        this.lock.lock();
        try {
            this.state = State.STOPPED;
        }
        finally {
            this.lock.unlock();
        }
    }

    private int migrate0(boolean logSkippedProject) throws Exception {
        int numMigratedProjects = 0;
        for (Project project : this.projectManager.list().values()) {
            String projectName = project.name();
            if ("dogma".equals(projectName)) continue;
            if ("dogma".equals(project.metaRepo().name())) {
                if (!logSkippedProject) continue;
                logger.debug("The project '{}' has already been migrated.", (Object)projectName);
                continue;
            }
            logger.info("Migrating meta repository to dogma repository in the project: {} ...", (Object)projectName);
            this.metadataService.updateRepositoryStatus(Author.SYSTEM, projectName, "dogma", RepositoryStatus.READ_ONLY).join();
            Thread.sleep(3000L);
            logger.info("Dogma repository in the project '{}' is set to read-only.", (Object)projectName);
            try {
                this.migrateMetaRepository(project);
                ++numMigratedProjects;
                logger.info("Meta repository in the project '{}' is migrated to dogma repository.", (Object)projectName);
            }
            catch (Throwable t) {
                logger.warn("Failed to migrate meta repository of {} project. Set back to active.", (Object)projectName, (Object)t);
                this.metadataService.updateRepositoryStatus(Author.SYSTEM, projectName, "dogma", RepositoryStatus.ACTIVE).join();
                throw t;
            }
            this.commandExecutor.execute(Command.resetMetaRepository(Author.SYSTEM, projectName)).join();
            this.metadataService.updateRepositoryStatus(Author.SYSTEM, projectName, "dogma", RepositoryStatus.ACTIVE).join();
            logger.info("Dogma repository of {} project is set to active.", (Object)projectName);
        }
        return numMigratedProjects;
    }

    private void logMigrationJob(int numMigratedProjects) throws Exception {
        ImmutableMap data = ImmutableMap.of((Object)"timestamp", (Object)Instant.now(), (Object)"numMigratedProjects", (Object)numMigratedProjects);
        Change change = Change.ofJsonUpsert((String)META_TO_DOGMA_MIGRATION_JOB, (String)Jackson.writeValueAsString((Object)data));
        Command<CommitResult> command = Command.push(Author.SYSTEM, "dogma", "dogma", Revision.HEAD, "Migrating meta repository to dogma repository has been done.", "", Markup.PLAINTEXT, change);
        this.executeCommand(command);
    }

    private void migrateMetaRepository(Project project) throws Exception {
        Repository metaRepository = (Repository)project.repos().get("meta");
        Map<String, Entry<?>> entryMap = metaRepository.find(Revision.HEAD, "/credentials/*.json,/repos/**.json").get();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(entryMap.size() + 1));
        for (Map.Entry<String, Entry<?>> entry : entryMap.entrySet()) {
            Entry<?> value = entry.getValue();
            builder.add((Object)Change.ofJsonUpsert((String)entry.getKey(), (JsonNode)((JsonNode)value.content())));
        }
        builder.add((Object)Change.ofJsonUpsert((String)META_TO_DOGMA_MIGRATED, (String)Jackson.writeValueAsString((Object)ImmutableMap.of((Object)"timestamp", (Object)Instant.now()))));
        this.executeCommand(Command.forcePush(Command.push(Author.SYSTEM, project.name(), "dogma", Revision.HEAD, "Migrate the meta repository to dogma repository", "", Markup.PLAINTEXT, builder.build())));
    }

    private void executeCommand(Command<CommitResult> command) throws InterruptedException, ExecutionException, TimeoutException {
        this.commandExecutor.execute(command).get(1L, TimeUnit.MINUTES);
    }

    boolean tryStop() {
        this.lock.lock();
        try {
            if (this.state == State.NOT_STARTED) {
                this.state = State.STOPPED;
                boolean bl = true;
                return bl;
            }
            boolean bl = this.state == State.STOPPED;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static enum State {
        NOT_STARTED,
        STARTED,
        STOPPED;

    }
}

