/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.internal.api.sysadmin.MirrorAccessControlRequest;
import com.linecorp.centraldogma.server.internal.storage.repository.HasId;
import com.linecorp.centraldogma.server.metadata.UserAndTimestamp;
import java.util.Objects;

public final class MirrorAccessControl
implements HasId<MirrorAccessControl> {
    private final String id;
    private final String targetPattern;
    private final boolean allow;
    private final String description;
    private final int order;
    private final UserAndTimestamp creation;

    static MirrorAccessControl from(MirrorAccessControlRequest request, Author author) {
        return new MirrorAccessControl(request.id(), request.targetPattern(), request.allow(), request.description(), request.order(), UserAndTimestamp.of(author));
    }

    @JsonCreator
    MirrorAccessControl(@JsonProperty(value="id") String id, @JsonProperty(value="targetPattern") String targetPattern, @JsonProperty(value="allow") boolean allow, @JsonProperty(value="description") String description, @JsonProperty(value="order") int order, @JsonProperty(value="creation") UserAndTimestamp creation) {
        this.id = Objects.requireNonNull(id, "id");
        this.targetPattern = Objects.requireNonNull(targetPattern, "targetPattern");
        this.allow = allow;
        this.description = Objects.requireNonNull(description, "description");
        this.creation = Objects.requireNonNull(creation, "creation");
        this.order = order;
    }

    @Override
    @JsonProperty
    public String id() {
        return this.id;
    }

    @JsonProperty
    public String targetPattern() {
        return this.targetPattern;
    }

    @JsonProperty
    public boolean allow() {
        return this.allow;
    }

    @JsonProperty
    public String description() {
        return this.description;
    }

    @JsonProperty
    public int order() {
        return this.order;
    }

    @JsonProperty
    public UserAndTimestamp creation() {
        return this.creation;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MirrorAccessControl)) {
            return false;
        }
        MirrorAccessControl that = (MirrorAccessControl)o;
        return this.allow == that.allow && this.order == that.order && this.id.equals(that.id) && this.targetPattern.equals(that.targetPattern) && this.description.equals(that.description) && this.creation.equals(that.creation);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.order, this.targetPattern, this.allow, this.description, this.creation);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("targetPattern", (Object)this.targetPattern).add("allow", this.allow).add("description", (Object)this.description).add("order", this.order).add("creation", (Object)this.creation).toString();
    }
}

