/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.mirror.Mirror;
import com.linecorp.centraldogma.server.mirror.MirrorResult;
import com.linecorp.centraldogma.server.mirror.MirrorTask;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.File;

final class InstrumentedMirroringJob {
    private final MeterRegistry meterRegistry;
    private final MirrorTask mirrorTask;
    private final Iterable<Tag> tags;

    private static Iterable<Tag> generateTags(Mirror mirror, String projectName) {
        return ImmutableList.of((Object)Tag.of((String)"project", (String)projectName), (Object)Tag.of((String)"direction", (String)mirror.direction().name()), (Object)Tag.of((String)"remoteBranch", (String)mirror.remoteBranch()), (Object)Tag.of((String)"remotePath", (String)mirror.remotePath()), (Object)Tag.of((String)"localRepo", (String)mirror.localRepo().name()), (Object)Tag.of((String)"localPath", (String)mirror.localPath()));
    }

    InstrumentedMirroringJob(MirrorTask mirrorTask, MeterRegistry meterRegistry) {
        this.mirrorTask = mirrorTask;
        this.meterRegistry = meterRegistry;
        this.tags = InstrumentedMirroringJob.generateTags(mirrorTask.mirror(), mirrorTask.mirror().localRepo().parent().name());
    }

    private Counter counter(boolean success) {
        return Counter.builder((String)"mirroring.result").tags(this.tags).tag("success", Boolean.toString(success)).register(this.meterRegistry);
    }

    MirrorResult run(File workDir, CommandExecutor executor, int maxNumFiles, long maxNumBytes) {
        try {
            MirrorResult mirrorResult = (MirrorResult)this.meterRegistry.timer("mirroring.task", this.tags).record(() -> this.mirrorTask.mirror().mirror(workDir, executor, maxNumFiles, maxNumBytes, this.mirrorTask.triggeredTime()));
            this.counter(true).increment();
            return mirrorResult;
        }
        catch (Exception e) {
            this.counter(false).increment();
            throw e;
        }
    }
}

