/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.ZoneConfig;
import com.linecorp.centraldogma.server.internal.mirror.MirrorSchedulingService;
import com.linecorp.centraldogma.server.mirror.MirroringServicePluginConfig;
import com.linecorp.centraldogma.server.plugin.Plugin;
import com.linecorp.centraldogma.server.plugin.PluginContext;
import com.linecorp.centraldogma.server.plugin.PluginTarget;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;

public final class DefaultMirroringServicePlugin
implements Plugin {
    @Nullable
    private volatile MirrorSchedulingService mirroringService;
    @Nullable
    private PluginTarget pluginTarget;

    @Nullable
    public static MirroringServicePluginConfig mirrorConfig(CentralDogmaConfig config) {
        return (MirroringServicePluginConfig)config.pluginConfigMap().get(MirroringServicePluginConfig.class);
    }

    @Override
    public PluginTarget target(CentralDogmaConfig config) {
        Objects.requireNonNull(config, "config");
        if (this.pluginTarget != null) {
            return this.pluginTarget;
        }
        MirroringServicePluginConfig mirrorConfig = DefaultMirroringServicePlugin.mirrorConfig(config);
        this.pluginTarget = mirrorConfig != null && mirrorConfig.zonePinned() ? PluginTarget.ZONE_LEADER_ONLY : PluginTarget.LEADER_ONLY;
        return this.pluginTarget;
    }

    @Override
    public synchronized CompletionStage<Void> start(PluginContext context) {
        Objects.requireNonNull(context, "context");
        MirrorSchedulingService mirroringService = this.mirroringService;
        if (mirroringService == null) {
            boolean runMigration;
            ZoneConfig zoneConfig;
            long maxNumBytesPerMirror;
            int maxNumFilesPerMirror;
            int numThreads;
            CentralDogmaConfig cfg = context.config();
            MirroringServicePluginConfig mirroringServicePluginConfig = DefaultMirroringServicePlugin.mirrorConfig(cfg);
            if (mirroringServicePluginConfig != null) {
                numThreads = mirroringServicePluginConfig.numMirroringThreads();
                maxNumFilesPerMirror = mirroringServicePluginConfig.maxNumFilesPerMirror();
                maxNumBytesPerMirror = mirroringServicePluginConfig.maxNumBytesPerMirror();
                if (mirroringServicePluginConfig.zonePinned()) {
                    zoneConfig = cfg.zone();
                    assert (zoneConfig != null) : "zonePinned is enabled but no zone configuration found";
                } else {
                    zoneConfig = null;
                }
                runMigration = mirroringServicePluginConfig.runMigration();
            } else {
                numThreads = MirroringServicePluginConfig.INSTANCE.numMirroringThreads();
                maxNumFilesPerMirror = MirroringServicePluginConfig.INSTANCE.maxNumFilesPerMirror();
                maxNumBytesPerMirror = MirroringServicePluginConfig.INSTANCE.maxNumBytesPerMirror();
                zoneConfig = null;
                runMigration = true;
            }
            this.mirroringService = mirroringService = new MirrorSchedulingService(new File(cfg.dataDir(), "_mirrors"), context.projectManager(), context.meterRegistry(), numThreads, maxNumFilesPerMirror, maxNumBytesPerMirror, zoneConfig, runMigration, context.mirrorAccessController());
        }
        mirroringService.start(context.commandExecutor());
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletionStage<Void> stop(PluginContext context) {
        MirrorSchedulingService mirroringService = this.mirroringService;
        if (mirroringService != null && mirroringService.isStarted()) {
            mirroringService.stop();
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Class<?> configType() {
        return MirroringServicePluginConfig.class;
    }

    @Nullable
    public MirrorSchedulingService mirroringService() {
        return this.mirroringService;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("configType", (Object)this.configType().getName()).add("target", (Object)this.pluginTarget).toString();
    }
}

