/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.credential;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.CredentialUtil;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.credential.Credential;
import com.linecorp.centraldogma.server.credential.LegacyCredential;
import com.linecorp.centraldogma.server.internal.credential.AbstractLegacyCredential;
import com.linecorp.centraldogma.server.internal.credential.PasswordCredential;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PasswordLegacyCredential
extends AbstractLegacyCredential {
    private static final Logger logger = LoggerFactory.getLogger(PasswordLegacyCredential.class);
    private final String username;
    private final String password;

    @JsonCreator
    public PasswordLegacyCredential(@JsonProperty(value="id") String id, @JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password) {
        super(id, enabled, "password");
        this.username = CredentialUtil.requireNonEmpty((String)username, (String)"username");
        this.password = Objects.requireNonNull(password, "password");
    }

    @JsonProperty(value="username")
    public String username() {
        return this.username;
    }

    public String password() {
        try {
            return CentralDogmaConfig.convertValue(this.password, "credentials.password");
        }
        catch (Throwable t) {
            logger.debug("Failed to convert the password of the credential. username: {}, id: {}", new Object[]{this.username, this.id(), t});
            return this.password;
        }
    }

    @JsonProperty(value="password")
    public String rawPassword() {
        return this.password;
    }

    @Override
    public Credential toNewCredential(String name) {
        return new PasswordCredential(name, this.username, this.password);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.username.hashCode();
        result = 31 * result + this.password.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PasswordLegacyCredential)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PasswordLegacyCredential that = (PasswordLegacyCredential)o;
        return this.username.equals(that.username) && this.password.equals(that.password);
    }

    @Override
    void addProperties(MoreObjects.ToStringHelper helper) {
        helper.add("username", (Object)this.username);
    }

    @Override
    public LegacyCredential withoutSecret() {
        return new PasswordLegacyCredential(this.id(), this.enabled(), this.username(), "****");
    }
}

