/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.sysadmin;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseEntity;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Consumes;
import com.linecorp.armeria.server.annotation.Default;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.armeria.server.annotation.ResponseConverter;
import com.linecorp.armeria.server.annotation.StatusCode;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresSystemAdministrator;
import com.linecorp.centraldogma.server.internal.api.converter.CreateApiResponseConverter;
import com.linecorp.centraldogma.server.internal.api.sysadmin.TokenLevelRequest;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import com.linecorp.centraldogma.server.metadata.Token;
import com.linecorp.centraldogma.server.metadata.User;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@ProducesJson
public class TokenService
extends AbstractService {
    private static final JsonNode activation = Jackson.valueToTree((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"op", (Object)"replace", (Object)"path", (Object)"/status", (Object)"value", (Object)"active")));
    private static final JsonNode deactivation = Jackson.valueToTree((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"op", (Object)"replace", (Object)"path", (Object)"/status", (Object)"value", (Object)"inactive")));
    private final MetadataService mds;

    public TokenService(CommandExecutor executor, MetadataService mds) {
        super(executor);
        this.mds = Objects.requireNonNull(mds, "mds");
    }

    @Get(value="/tokens")
    public Collection<Token> listTokens(User loginUser) {
        if (loginUser.isSystemAdmin()) {
            return this.mds.getTokens().appIds().values();
        }
        return this.mds.getTokens().withoutSecret().appIds().values();
    }

    @Post(value="/tokens")
    @StatusCode(value=201)
    @ResponseConverter(value=CreateApiResponseConverter.class)
    public CompletableFuture<ResponseEntity<Token>> createToken(@Param String appId, @Param @Default(value="false") boolean isAdmin, @Param @Default(value="false") boolean isSystemAdmin, @Param @Nullable String secret, Author author, User loginUser) {
        boolean isSystemAdminToken = isSystemAdmin || isAdmin;
        Preconditions.checkArgument((!isSystemAdminToken || loginUser.isSystemAdmin() ? 1 : 0) != 0, (Object)"Only system administrators are allowed to create a system admin-level token.");
        Preconditions.checkArgument((secret == null || loginUser.isSystemAdmin() ? 1 : 0) != 0, (Object)"Only system administrators are allowed to create a new token from  the given secret string");
        CompletableFuture<Revision> tokenFuture = secret != null ? this.mds.createToken(author, appId, secret, isSystemAdminToken) : this.mds.createToken(author, appId, isSystemAdminToken);
        return ((CompletableFuture)tokenFuture.thenCompose(unused -> this.fetchTokensByAppId(appId))).thenApply(token -> {
            ResponseHeaders headers = ResponseHeaders.of((HttpStatus)HttpStatus.CREATED, (CharSequence)HttpHeaderNames.LOCATION, (String)("/tokens/" + appId));
            return ResponseEntity.of((ResponseHeaders)headers, (Object)token);
        });
    }

    @Delete(value="/tokens/{appId}")
    public CompletableFuture<Token> deleteToken(ServiceRequestContext ctx, @Param String appId, Author author, User loginUser) {
        return this.getTokenOrRespondForbidden(ctx, appId, loginUser).thenCompose(token -> this.mds.destroyToken(author, appId).thenApply(unused -> token.withoutSecret()));
    }

    @Delete(value="/tokens/{appId}/removed")
    @RequiresSystemAdministrator
    public CompletableFuture<Token> purgeToken(ServiceRequestContext ctx, @Param String appId, Author author, User loginUser) {
        return this.getTokenOrRespondForbidden(ctx, appId, loginUser).thenApplyAsync(token -> {
            this.mds.purgeToken(author, appId);
            return token.withoutSecret();
        }, (Executor)ctx.blockingTaskExecutor());
    }

    @Patch(value="/tokens/{appId}")
    @Consumes(value="application/json-patch+json")
    public CompletableFuture<Token> updateToken(ServiceRequestContext ctx, @Param String appId, JsonNode node, Author author, User loginUser) {
        return this.getTokenOrRespondForbidden(ctx, appId, loginUser).thenCompose(token -> {
            if (token.isDeleted()) {
                throw new IllegalArgumentException("You can't update the status of the token scheduled for deletion.");
            }
            if (node.equals((Object)activation)) {
                return this.mds.activateToken(author, appId).thenApply(unused -> token.withoutSecret());
            }
            if (node.equals((Object)deactivation)) {
                return this.mds.deactivateToken(author, appId).thenApply(unused -> token.withoutSecret());
            }
            throw new IllegalArgumentException("Unsupported JSON patch: " + node + " (expected: " + activation + " or " + deactivation + ')');
        });
    }

    @Patch(value="/tokens/{appId}/level")
    @RequiresSystemAdministrator
    public CompletableFuture<Token> updateTokenLevel(ServiceRequestContext ctx, @Param String appId, TokenLevelRequest tokenLevelRequest, Author author, User loginUser) {
        String newTokenLevel = tokenLevelRequest.level().toLowerCase();
        Preconditions.checkArgument(("user".equals(newTokenLevel) || "admin".equals(newTokenLevel) || "systemadmin".equals(newTokenLevel) ? 1 : 0) != 0, (Object)("token level: %s (expected: user or systemadmin)" + tokenLevelRequest.level()));
        return this.getTokenOrRespondForbidden(ctx, appId, loginUser).thenCompose(token -> {
            boolean toBeSystemAdmin = false;
            switch (newTokenLevel) {
                case "user": {
                    if (token.isSystemAdmin()) break;
                    throw HttpStatusException.of((HttpStatus)HttpStatus.NOT_MODIFIED);
                }
                case "admin": 
                case "systemadmin": {
                    if (token.isSystemAdmin()) {
                        throw HttpStatusException.of((HttpStatus)HttpStatus.NOT_MODIFIED);
                    }
                    toBeSystemAdmin = true;
                }
            }
            return this.mds.updateTokenLevel(author, appId, toBeSystemAdmin).thenCompose(unused -> this.fetchTokensByAppId(appId).thenApply(Token::withoutSecret));
        });
    }

    private CompletableFuture<Token> fetchTokensByAppId(String appId) {
        return this.mds.fetchTokens().thenApply(tokens -> tokens.get(appId));
    }

    private CompletableFuture<Token> getTokenOrRespondForbidden(ServiceRequestContext ctx, String appId, User loginUser) {
        return this.fetchTokensByAppId(appId).thenApply(token -> {
            if (!loginUser.isSystemAdmin() && !token.creation().user().equals(loginUser.id())) {
                return (Token)HttpApiUtil.throwResponse(ctx, HttpStatus.FORBIDDEN, "Unauthorized token: %s", token);
            }
            return token;
        });
    }
}

