/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.sysadmin;

import com.linecorp.armeria.server.annotation.ConsumesJson;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.armeria.server.annotation.Put;
import com.linecorp.armeria.server.annotation.StatusCode;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresSystemAdministrator;
import com.linecorp.centraldogma.server.internal.api.sysadmin.MirrorAccessControlRequest;
import com.linecorp.centraldogma.server.internal.mirror.DefaultMirrorAccessController;
import com.linecorp.centraldogma.server.internal.mirror.MirrorAccessControl;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

@ProducesJson
@ConsumesJson
@RequiresSystemAdministrator
public final class MirrorAccessControlService
extends AbstractService {
    public static final String MIRROR_ACCESS_CONTROL_PATH = "/mirror-access-control/";
    private final DefaultMirrorAccessController accessController;

    public MirrorAccessControlService(CommandExecutor executor, DefaultMirrorAccessController accessController) {
        super(executor);
        this.accessController = Objects.requireNonNull(accessController, "accessController");
    }

    @Get(value="/mirror/access")
    public CompletableFuture<List<MirrorAccessControl>> list() {
        return this.accessController.list();
    }

    @StatusCode(value=201)
    @Post(value="/mirror/access")
    public CompletableFuture<MirrorAccessControl> create(MirrorAccessControlRequest request, Author author) {
        return this.accessController.add(request, author);
    }

    @Put(value="/mirror/access")
    public CompletableFuture<MirrorAccessControl> update(MirrorAccessControlRequest request, Author author) {
        return this.accessController.update(request, author);
    }

    @Get(value="/mirror/access/{id}")
    public CompletableFuture<MirrorAccessControl> get(@Param String id) {
        return this.accessController.get(id);
    }

    @Delete(value="/mirror/access/{id}")
    public CompletableFuture<Void> delete(@Param String id, Author author) {
        return this.accessController.delete(id, author);
    }
}

