/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.sysadmin;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.internal.storage.repository.git.GitCrudRepository;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class MirrorAccessControlRequest {
    private final String id;
    private final String targetPattern;
    private final boolean allow;
    private final String description;
    private final int order;

    @JsonCreator
    public MirrorAccessControlRequest(@JsonProperty(value="id") String id, @JsonProperty(value="targetPattern") String targetPattern, @JsonProperty(value="allow") boolean allow, @JsonProperty(value="description") String description, @JsonProperty(value="order") int order) {
        this.id = GitCrudRepository.validateId(id);
        try {
            Pattern.compile(targetPattern);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("invalid targetPattern: " + targetPattern, e);
        }
        this.targetPattern = Objects.requireNonNull(targetPattern, "targetPattern");
        this.allow = allow;
        this.description = Objects.requireNonNull(description, "description");
        this.order = order;
    }

    @JsonProperty
    public String id() {
        return this.id;
    }

    @JsonProperty
    public String targetPattern() {
        return this.targetPattern;
    }

    @JsonProperty
    public boolean allow() {
        return this.allow;
    }

    @JsonProperty
    public String description() {
        return this.description;
    }

    @JsonProperty
    public int order() {
        return this.order;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MirrorAccessControlRequest)) {
            return false;
        }
        MirrorAccessControlRequest that = (MirrorAccessControlRequest)o;
        return this.allow == that.allow && this.order == that.order && this.id.equals(that.id) && this.targetPattern.equals(that.targetPattern) && this.description.equals(that.description);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.targetPattern, this.allow, this.description, this.order);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("targetPattern", (Object)this.targetPattern).add("allow", this.allow).add("description", (Object)this.description).add("order", this.order).toString();
    }
}

