/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.converter;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectApiManager;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.lang.reflect.ParameterizedType;
import java.util.Objects;
import javax.annotation.Nullable;

public final class HttpApiRequestConverter
implements RequestConverterFunction {
    private final ProjectApiManager projectApiManager;

    public HttpApiRequestConverter(ProjectApiManager projectApiManager) {
        this.projectApiManager = Objects.requireNonNull(projectApiManager, "projectApiManager");
    }

    public Object convertRequest(ServiceRequestContext ctx, AggregatedHttpRequest request, Class<?> expectedResultType, @Nullable ParameterizedType expectedParameterizedResultType) throws Exception {
        User user = AuthUtil.currentUser(ctx);
        if (expectedResultType == Project.class) {
            String projectName = ctx.pathParam("projectName");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectName) ? 1 : 0) != 0, (Object)"project name should not be null or empty.");
            return this.projectApiManager.getProject(projectName, user);
        }
        if (expectedResultType == Repository.class) {
            String projectName = ctx.pathParam("projectName");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectName) ? 1 : 0) != 0, (Object)"project name should not be null or empty.");
            String repositoryName = ctx.pathParam("repoName");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)repositoryName) ? 1 : 0) != 0, (Object)"repository name should not be null or empty.");
            if (Project.isInternalRepo(repositoryName) && !user.isSystemAdmin()) {
                return HttpApiUtil.throwResponse(ctx, HttpStatus.FORBIDDEN, "Repository '%s/%s' can be accessed only by a system administrator.", projectName, "dogma");
            }
            return this.projectApiManager.getProject(projectName, user).repos().get(repositoryName);
        }
        if (expectedResultType == Author.class) {
            return AuthUtil.currentAuthor(ctx);
        }
        if (expectedResultType == User.class) {
            return user;
        }
        return RequestConverterFunction.fallthrough();
    }
}

