/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.auth;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.annotation.DecoratorFactoryFunction;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresSystemAdministrator;
import com.linecorp.centraldogma.server.metadata.User;
import java.util.function.Function;

public final class RequiresSystemAdministratorDecorator
extends SimpleDecoratingHttpService {
    RequiresSystemAdministratorDecorator(HttpService delegate) {
        super(delegate);
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        User user = AuthUtil.currentUser(ctx);
        if (user.isSystemAdmin()) {
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
        }
        return (HttpResponse)HttpApiUtil.throwResponse(ctx, HttpStatus.FORBIDDEN, "You must be a system administrator to perform this operation.");
    }

    public static final class RequiresSystemAdministratorDecoratorFactory
    implements DecoratorFactoryFunction<RequiresSystemAdministrator> {
        public Function<? super HttpService, ? extends HttpService> newDecorator(RequiresSystemAdministrator parameter) {
            return RequiresSystemAdministratorDecorator::new;
        }
    }
}

