/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.auth;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.logging.LogLevel;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.centraldogma.server.internal.admin.auth.AbstractAuthorizer;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.metadata.Token;
import com.linecorp.centraldogma.server.metadata.TokenNotFoundException;
import com.linecorp.centraldogma.server.metadata.Tokens;
import com.linecorp.centraldogma.server.metadata.UserWithToken;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationTokenAuthorizer
extends AbstractAuthorizer {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationTokenAuthorizer.class);
    private final Function<String, Token> tokenLookupFunc;

    public ApplicationTokenAuthorizer(Function<String, Token> tokenLookupFunc) {
        this.tokenLookupFunc = Objects.requireNonNull(tokenLookupFunc, "tokenLookupFunc");
    }

    @Override
    protected CompletionStage<Boolean> authorize(ServiceRequestContext ctx, HttpRequest req, String accessToken) {
        if (!Tokens.isValidSecret(accessToken)) {
            return CompletableFuture.completedFuture(false);
        }
        try {
            Token appToken = this.tokenLookupFunc.apply(accessToken);
            if (appToken != null && appToken.isActive()) {
                String appId = appToken.appId();
                StringBuilder login = new StringBuilder(appId);
                InetSocketAddress ra = ctx.remoteAddress();
                if (ra instanceof InetSocketAddress) {
                    login.append('@').append(ra.getHostString());
                }
                ctx.logBuilder().authenticatedUser("app/" + appId);
                UserWithToken user = new UserWithToken(login.toString(), appToken);
                AuthUtil.setCurrentUser(ctx, user);
                HttpApiUtil.setVerboseResponses(ctx, user);
                return UnmodifiableFuture.completedFuture((Object)true);
            }
            return UnmodifiableFuture.completedFuture((Object)false);
        }
        catch (Throwable cause) {
            cause = Exceptions.peel((Throwable)cause);
            LogLevel level = cause instanceof IllegalArgumentException || cause instanceof TokenNotFoundException ? LogLevel.DEBUG : LogLevel.WARN;
            level.log(logger, "Failed to authorize an application token: token={}, addr={}", (Object)ApplicationTokenAuthorizer.maskToken(accessToken), (Object)ctx.clientAddress(), (Object)cause);
            return UnmodifiableFuture.completedFuture((Object)false);
        }
    }

    private static String maskToken(String token) {
        if (!token.startsWith("appToken-")) {
            return token;
        }
        int lastDash = token.lastIndexOf(45);
        if (lastDash == -1) {
            return token;
        }
        return token.substring(0, lastDash) + "-<redacted>";
    }
}

