/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.annotation.Consumes;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.ProjectRole;
import com.linecorp.centraldogma.common.RepositoryRole;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.jsonpatch.JsonPatchOperation;
import com.linecorp.centraldogma.common.jsonpatch.ReplaceOperation;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatch;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresProjectRole;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresRepositoryRole;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import com.linecorp.centraldogma.server.metadata.ProjectRoles;
import com.linecorp.centraldogma.server.metadata.Token;
import com.linecorp.centraldogma.server.metadata.User;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

@ProducesJson
public class MetadataApiService
extends AbstractService {
    private final MetadataService mds;
    private final Function<String, String> loginNameNormalizer;

    public MetadataApiService(CommandExecutor executor, MetadataService mds, Function<String, String> loginNameNormalizer) {
        super(executor);
        this.mds = Objects.requireNonNull(mds, "mds");
        this.loginNameNormalizer = Objects.requireNonNull(loginNameNormalizer, "loginNameNormalizer");
    }

    @RequiresProjectRole(value=ProjectRole.OWNER)
    @Post(value="/metadata/{projectName}/members")
    public CompletableFuture<Revision> addMember(@Param String projectName, IdAndProjectRole request, Author author) {
        User member = new User(this.loginNameNormalizer.apply(request.id()));
        return this.mds.addMember(author, projectName, member, request.role());
    }

    @RequiresProjectRole(value=ProjectRole.OWNER)
    @Patch(value="/metadata/{projectName}/members/{memberId}")
    @Consumes(value="application/json-patch+json")
    public CompletableFuture<Revision> updateMember(@Param String projectName, @Param String memberId, JsonPatch jsonPatch, Author author) {
        ReplaceOperation operation = MetadataApiService.ensureSingleReplaceOperation(jsonPatch, "/role");
        ProjectRole role = ProjectRole.of((JsonNode)operation.value());
        User member = new User(this.loginNameNormalizer.apply(MetadataApiService.urlDecode(memberId)));
        return this.mds.getMember(projectName, member).thenCompose(unused -> this.mds.updateMemberRole(author, projectName, member, role));
    }

    @RequiresProjectRole(value=ProjectRole.OWNER)
    @Delete(value="/metadata/{projectName}/members/{memberId}")
    public CompletableFuture<Revision> removeMember(@Param String projectName, @Param String memberId, Author author) {
        User member = new User(this.loginNameNormalizer.apply(MetadataApiService.urlDecode(memberId)));
        return this.mds.getMember(projectName, member).thenCompose(unused -> this.mds.removeMember(author, projectName, member));
    }

    @RequiresProjectRole(value=ProjectRole.OWNER)
    @Post(value="/metadata/{projectName}/tokens")
    public CompletableFuture<Revision> addToken(@Param String projectName, IdAndProjectRole request, Author author) {
        Token token = this.mds.findTokenByAppId(request.id());
        return this.mds.addToken(author, projectName, token.appId(), request.role());
    }

    @RequiresProjectRole(value=ProjectRole.OWNER)
    @Patch(value="/metadata/{projectName}/tokens/{appId}")
    @Consumes(value="application/json-patch+json")
    public CompletableFuture<Revision> updateTokenRole(@Param String projectName, @Param String appId, JsonPatch jsonPatch, Author author) {
        ReplaceOperation operation = MetadataApiService.ensureSingleReplaceOperation(jsonPatch, "/role");
        ProjectRole role = ProjectRole.of((JsonNode)operation.value());
        Token token = this.mds.findTokenByAppId(appId);
        return this.mds.updateTokenRole(author, projectName, token, role);
    }

    @RequiresProjectRole(value=ProjectRole.OWNER)
    @Delete(value="/metadata/{projectName}/tokens/{appId}")
    public CompletableFuture<Revision> removeToken(@Param String projectName, @Param String appId, Author author) {
        Token token = this.mds.findTokenByAppId(appId);
        return this.mds.removeToken(author, projectName, token.appId());
    }

    @RequiresRepositoryRole(value=RepositoryRole.ADMIN)
    @Post(value="/metadata/{projectName}/repos/{repoName}/roles/projects")
    public CompletableFuture<Revision> updateRepositoryProjectRoles(@Param String projectName, @Param String repoName, JsonNode payload, Author author) throws JsonProcessingException {
        String role;
        JsonNode guest = payload.get("guest");
        if (guest.isTextual() && "WRITE".equals(role = guest.asText())) {
            throw new IllegalArgumentException("WRITE is not allowed for GUEST");
        }
        ProjectRoles projectRoles = (ProjectRoles)Jackson.treeToValue((TreeNode)payload, ProjectRoles.class);
        return this.mds.updateRepositoryProjectRoles(author, projectName, repoName, projectRoles);
    }

    @RequiresRepositoryRole(value=RepositoryRole.ADMIN)
    @Post(value="/metadata/{projectName}/repos/{repoName}/roles/users")
    public CompletableFuture<Revision> addUserRepositoryRole(@Param String projectName, @Param String repoName, IdAndRepositoryRole idAndRepositoryRole, Author author) {
        User member = new User(this.loginNameNormalizer.apply(idAndRepositoryRole.id()));
        return this.mds.addUserRepositoryRole(author, projectName, repoName, member, idAndRepositoryRole.role());
    }

    @RequiresRepositoryRole(value=RepositoryRole.ADMIN)
    @Delete(value="/metadata/{projectName}/repos/{repoName}/roles/users/{memberId}")
    public CompletableFuture<Revision> removeUserRepositoryRole(@Param String projectName, @Param String repoName, @Param String memberId, Author author) {
        User member = new User(this.loginNameNormalizer.apply(MetadataApiService.urlDecode(memberId)));
        return this.mds.findRepositoryRole(projectName, repoName, member).thenCompose(unused -> this.mds.removeUserRepositoryRole(author, projectName, repoName, member));
    }

    @RequiresRepositoryRole(value=RepositoryRole.ADMIN)
    @Post(value="/metadata/{projectName}/repos/{repoName}/roles/tokens")
    public CompletableFuture<Revision> addTokenRepositoryRole(@Param String projectName, @Param String repoName, IdAndRepositoryRole tokenAndRepositoryRole, Author author) {
        return this.mds.addTokenRepositoryRole(author, projectName, repoName, tokenAndRepositoryRole.id(), tokenAndRepositoryRole.role());
    }

    @RequiresRepositoryRole(value=RepositoryRole.ADMIN)
    @Delete(value="/metadata/{projectName}/repos/{repoName}/roles/tokens/{appId}")
    public CompletableFuture<Revision> removeTokenRepositoryRole(@Param String projectName, @Param String repoName, @Param String appId, Author author) {
        Token token = this.mds.findTokenByAppId(appId);
        return this.mds.removeTokenRepositoryRole(author, projectName, repoName, appId);
    }

    private static ReplaceOperation ensureSingleReplaceOperation(JsonPatch patch, String expectedPath) {
        List operations = patch.operations();
        Preconditions.checkArgument((operations.size() == 1 ? 1 : 0) != 0, (Object)("Should be a single JSON patch operation in the list: " + operations.size()));
        JsonPatchOperation operation = (JsonPatchOperation)patch.operations().get(0);
        Preconditions.checkArgument((boolean)(operation instanceof ReplaceOperation), (Object)("Should be a replace operation: " + operation));
        Preconditions.checkArgument((boolean)expectedPath.equals(operation.path().toString()), (Object)("Invalid path value: " + operation.path()));
        return (ReplaceOperation)operation;
    }

    private static String urlDecode(String input) {
        try {
            return URLDecoder.decode(input, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return (String)Exceptions.throwUnsafely((Throwable)e);
        }
    }

    public static final class IdAndProjectRole {
        private final String id;
        private final ProjectRole role;

        @JsonCreator
        @VisibleForTesting
        public IdAndProjectRole(@JsonProperty(value="id") String id, @JsonProperty(value="role") ProjectRole role) {
            this.id = Objects.requireNonNull(id, "id");
            Objects.requireNonNull(role, "role");
            Preconditions.checkArgument((role == ProjectRole.OWNER || role == ProjectRole.MEMBER ? 1 : 0) != 0, (Object)("Invalid role: " + role + " (expected: '" + ProjectRole.OWNER + "' or '" + ProjectRole.MEMBER + "')"));
            this.role = role;
        }

        @JsonProperty
        public String id() {
            return this.id;
        }

        @JsonProperty
        public ProjectRole role() {
            return this.role;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id()).add("role", (Object)this.role()).toString();
        }
    }

    public static final class IdAndRepositoryRole {
        private final String id;
        private final RepositoryRole role;

        @JsonCreator
        @VisibleForTesting
        public IdAndRepositoryRole(@JsonProperty(value="id") String id, @JsonProperty(value="role") RepositoryRole role) {
            this.id = Objects.requireNonNull(id, "id");
            this.role = Objects.requireNonNull(role, "role");
        }

        @JsonProperty
        public String id() {
            return this.id;
        }

        @JsonProperty
        public RepositoryRole role() {
            return this.role;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id()).add("role", (Object)this.role()).toString();
        }
    }
}

