/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.RequestTimeoutException;
import com.linecorp.armeria.server.ServerErrorHandler;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.centraldogma.common.ApiRequestTimeoutException;
import com.linecorp.centraldogma.common.AuthorizationException;
import com.linecorp.centraldogma.common.ChangeConflictException;
import com.linecorp.centraldogma.common.EntryNoContentException;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.InvalidPushException;
import com.linecorp.centraldogma.common.LockAcquireTimeoutException;
import com.linecorp.centraldogma.common.MirrorAccessException;
import com.linecorp.centraldogma.common.MirrorException;
import com.linecorp.centraldogma.common.PermissionException;
import com.linecorp.centraldogma.common.ProjectExistsException;
import com.linecorp.centraldogma.common.ProjectNotFoundException;
import com.linecorp.centraldogma.common.QueryExecutionException;
import com.linecorp.centraldogma.common.ReadOnlyException;
import com.linecorp.centraldogma.common.RedundantChangeException;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.common.RevisionNotFoundException;
import com.linecorp.centraldogma.common.ShuttingDownException;
import com.linecorp.centraldogma.common.TextPatchConflictException;
import com.linecorp.centraldogma.common.jsonpatch.JsonPatchConflictException;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.internal.api.ContentServiceV1;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.storage.RequestAlreadyTimedOutException;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryMetadataException;
import com.linecorp.centraldogma.server.metadata.MemberNotFoundException;
import com.linecorp.centraldogma.server.metadata.TokenNotFoundException;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;

public final class HttpApiExceptionHandler
implements ServerErrorHandler {
    private static final Map<Class<?>, BiFunction<ServiceRequestContext, Throwable, HttpResponse>> exceptionHandlers;

    public HttpResponse onServiceException(ServiceRequestContext ctx, Throwable cause) {
        Throwable peeledCause = Exceptions.peel((Throwable)cause);
        if (peeledCause instanceof HttpStatusException || peeledCause instanceof HttpResponseException) {
            return null;
        }
        BiFunction<ServiceRequestContext, Throwable, HttpResponse> func = exceptionHandlers.get(peeledCause.getClass());
        if (func != null) {
            ctx.setShouldReportUnloggedExceptions(false);
            return func.apply(ctx, peeledCause);
        }
        if (peeledCause instanceof ShuttingDownException && Boolean.TRUE.equals(ctx.attr(ContentServiceV1.IS_WATCH_REQUEST))) {
            ctx.setShouldReportUnloggedExceptions(false);
            return HttpResponse.of((HttpStatus)HttpStatus.NOT_MODIFIED);
        }
        if (peeledCause instanceof IllegalArgumentException) {
            ctx.setShouldReportUnloggedExceptions(false);
            return HttpApiUtil.newResponse(ctx, HttpStatus.BAD_REQUEST, peeledCause);
        }
        if (peeledCause instanceof RequestAlreadyTimedOutException) {
            ctx.setShouldReportUnloggedExceptions(false);
            return HttpApiUtil.newResponse(ctx, HttpStatus.SERVICE_UNAVAILABLE, peeledCause);
        }
        if (peeledCause instanceof RequestTimeoutException) {
            ctx.setShouldReportUnloggedExceptions(false);
            return HttpApiUtil.newResponse(ctx, HttpStatus.SERVICE_UNAVAILABLE, (Throwable)new ApiRequestTimeoutException("Request timed out", peeledCause));
        }
        return HttpApiUtil.newResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, peeledCause);
    }

    @Nonnull
    public AggregatedHttpResponse renderStatus(@Nullable ServiceRequestContext ctx, ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        return HttpApiUtil.newAggregatedResponse(ctx, status, cause, description);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ChangeConflictException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.CONFLICT, cause, "The given changeset or revision has a conflict.")).put(EntryNotFoundException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.NOT_FOUND, cause, "Entry '%s' does not exist.", cause.getMessage())).put(EntryNoContentException.class, (ctx, cause) -> HttpResponse.of((HttpStatus)HttpStatus.NO_CONTENT)).put(ProjectExistsException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.CONFLICT, cause, "Project '%s' exists already.", cause.getMessage())).put(ProjectNotFoundException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.NOT_FOUND, cause, "Project '%s' does not exist.", cause.getMessage())).put(RedundantChangeException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.CONFLICT, cause, "The given changeset does not change anything.")).put(RepositoryExistsException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.CONFLICT, cause, "Repository '%s' exists already.", cause.getMessage())).put(JsonPatchConflictException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.CONFLICT, cause)).put(TextPatchConflictException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.CONFLICT, cause)).put(RepositoryMetadataException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, cause)).put(RepositoryNotFoundException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.NOT_FOUND, cause, "Repository '%s' does not exist.", cause.getMessage())).put(RevisionNotFoundException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.NOT_FOUND, cause, "Revision %s does not exist.", cause.getMessage())).put(TokenNotFoundException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.NOT_FOUND, cause, cause.getMessage())).put(MemberNotFoundException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.NOT_FOUND, cause, cause.getMessage())).put(QueryExecutionException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.BAD_REQUEST, cause)).put(UnsupportedOperationException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.BAD_REQUEST, cause)).put(InvalidPushException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.BAD_REQUEST, cause)).put(ReadOnlyException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.SERVICE_UNAVAILABLE, cause)).put(MirrorException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, cause)).put(MirrorAccessException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.FORBIDDEN, cause)).put(AuthorizationException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.UNAUTHORIZED, cause)).put(PermissionException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.FORBIDDEN, cause)).put(LockAcquireTimeoutException.class, (ctx, cause) -> HttpApiUtil.newResponse(ctx, HttpStatus.SERVICE_UNAVAILABLE, cause));
        exceptionHandlers = builder.build();
    }
}

