/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.command;

import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.centraldogma.common.ReadOnlyException;
import com.linecorp.centraldogma.common.RepositoryStatus;
import com.linecorp.centraldogma.server.auth.Session;
import com.linecorp.centraldogma.server.auth.SessionManager;
import com.linecorp.centraldogma.server.command.AbstractCommandExecutor;
import com.linecorp.centraldogma.server.command.AbstractPushCommand;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.command.CreateProjectCommand;
import com.linecorp.centraldogma.server.command.CreateRepositoryCommand;
import com.linecorp.centraldogma.server.command.CreateSessionCommand;
import com.linecorp.centraldogma.server.command.ForcePushCommand;
import com.linecorp.centraldogma.server.command.MigrateToEncryptedRepositoryCommand;
import com.linecorp.centraldogma.server.command.NormalizableCommit;
import com.linecorp.centraldogma.server.command.NormalizingPushCommand;
import com.linecorp.centraldogma.server.command.PurgeProjectCommand;
import com.linecorp.centraldogma.server.command.PurgeRepositoryCommand;
import com.linecorp.centraldogma.server.command.PushAsIsCommand;
import com.linecorp.centraldogma.server.command.RemoveProjectCommand;
import com.linecorp.centraldogma.server.command.RemoveRepositoryCommand;
import com.linecorp.centraldogma.server.command.RemoveSessionCommand;
import com.linecorp.centraldogma.server.command.RepositoryCommand;
import com.linecorp.centraldogma.server.command.ResetMetaRepositoryCommand;
import com.linecorp.centraldogma.server.command.TransformCommand;
import com.linecorp.centraldogma.server.command.UnremoveProjectCommand;
import com.linecorp.centraldogma.server.command.UnremoveRepositoryCommand;
import com.linecorp.centraldogma.server.command.UpdateServerStatusCommand;
import com.linecorp.centraldogma.server.management.ServerStatusManager;
import com.linecorp.centraldogma.server.metadata.ProjectMetadata;
import com.linecorp.centraldogma.server.metadata.RepositoryMetadata;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageManager;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.storage.repository.MetaRepository;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import com.linecorp.centraldogma.server.storage.repository.RepositoryManager;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneCommandExecutor
extends AbstractCommandExecutor {
    private static final Logger logger = LoggerFactory.getLogger(StandaloneCommandExecutor.class);
    private final ProjectManager projectManager;
    private final Executor repositoryWorker;
    @Nullable
    private final SessionManager sessionManager;
    private final EncryptionStorageManager encryptionStorageManager;
    private final ServerStatusManager serverStatusManager;

    public StandaloneCommandExecutor(ProjectManager projectManager, Executor repositoryWorker, ServerStatusManager serverStatusManager, @Nullable SessionManager sessionManager, EncryptionStorageManager encryptionStorageManager, @Nullable Consumer<CommandExecutor> onTakeLeadership, @Nullable Consumer<CommandExecutor> onReleaseLeadership, @Nullable Consumer<CommandExecutor> onTakeZoneLeadership, @Nullable Consumer<CommandExecutor> onReleaseZoneLeadership) {
        super(onTakeLeadership, onReleaseLeadership, onTakeZoneLeadership, onReleaseZoneLeadership);
        this.projectManager = Objects.requireNonNull(projectManager, "projectManager");
        this.repositoryWorker = Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        this.serverStatusManager = Objects.requireNonNull(serverStatusManager, "serverStatusManager");
        this.sessionManager = sessionManager;
        this.encryptionStorageManager = Objects.requireNonNull(encryptionStorageManager, "encryptionStorageManager");
    }

    @Override
    public int replicaId() {
        return 0;
    }

    @Override
    protected void doStart(@Nullable Runnable onTakeLeadership, @Nullable Runnable onReleaseLeadership, @Nullable Runnable onTakeZoneLeadership, @Nullable Runnable onReleaseZoneLeadership) {
        if (onTakeLeadership != null) {
            onTakeLeadership.run();
        }
        if (onTakeZoneLeadership != null) {
            onTakeZoneLeadership.run();
        }
    }

    @Override
    protected void doStop(@Nullable Runnable onReleaseLeadership, @Nullable Runnable onReleaseZoneLeadership) {
        if (onReleaseLeadership != null) {
            onReleaseLeadership.run();
        }
        if (onReleaseZoneLeadership != null) {
            onReleaseZoneLeadership.run();
        }
    }

    @Override
    protected <T> CompletableFuture<T> doExecute(Command<T> command) throws Exception {
        this.throwExceptionIfRepositoryNotWritable(command);
        return this.doExecute0(command);
    }

    private void throwExceptionIfRepositoryNotWritable(Command<?> command) throws Exception {
        if (command instanceof NormalizableCommit) {
            assert (command instanceof RepositoryCommand);
            RepositoryCommand repositoryCommand = (RepositoryCommand)command;
            if ("dogma".equals(repositoryCommand.projectName())) {
                return;
            }
            String repoName = repositoryCommand.repositoryName();
            if ("meta".equals(repoName)) {
                repoName = "dogma";
            }
            ProjectMetadata metadata = ((Project)this.projectManager.get(repositoryCommand.projectName())).metadata();
            assert (metadata != null);
            RepositoryMetadata repositoryMetadata = metadata.repos().get(repoName);
            if (repositoryMetadata == null) {
                return;
            }
            if (repositoryMetadata.status() == RepositoryStatus.READ_ONLY) {
                throw new ReadOnlyException("The repository is in read-only. command: " + repositoryCommand);
            }
        }
    }

    private <T> CompletableFuture<T> doExecute0(Command<T> command) throws Exception {
        if (command instanceof CreateProjectCommand) {
            return this.createProject((CreateProjectCommand)command);
        }
        if (command instanceof ResetMetaRepositoryCommand) {
            return this.resetMetaRepository((ResetMetaRepositoryCommand)command);
        }
        if (command instanceof RemoveProjectCommand) {
            return this.removeProject((RemoveProjectCommand)command);
        }
        if (command instanceof UnremoveProjectCommand) {
            return this.unremoveProject((UnremoveProjectCommand)command);
        }
        if (command instanceof PurgeProjectCommand) {
            return this.purgeProject((PurgeProjectCommand)command);
        }
        if (command instanceof CreateRepositoryCommand) {
            return this.createRepository((CreateRepositoryCommand)command);
        }
        if (command instanceof RemoveRepositoryCommand) {
            return this.removeRepository((RemoveRepositoryCommand)command);
        }
        if (command instanceof UnremoveRepositoryCommand) {
            return this.unremoveRepository((UnremoveRepositoryCommand)command);
        }
        if (command instanceof PurgeRepositoryCommand) {
            return this.purgeRepository((PurgeRepositoryCommand)command);
        }
        if (command instanceof MigrateToEncryptedRepositoryCommand) {
            if (!this.encryptionStorageManager.enabled()) {
                throw new IllegalStateException("Encryption is not enabled. command: " + command);
            }
            return this.migrateToEncryptedRepository((MigrateToEncryptedRepositoryCommand)command);
        }
        if (command instanceof NormalizingPushCommand) {
            return this.push((NormalizingPushCommand)command, true);
        }
        if (command instanceof PushAsIsCommand) {
            return this.push((PushAsIsCommand)command, false).thenApply(CommitResult::revision);
        }
        if (command instanceof TransformCommand) {
            return this.push((TransformCommand)command, true);
        }
        if (command instanceof CreateSessionCommand) {
            return this.createSession((CreateSessionCommand)command);
        }
        if (command instanceof RemoveSessionCommand) {
            return this.removeSession((RemoveSessionCommand)command);
        }
        if (command instanceof UpdateServerStatusCommand) {
            return this.updateServerStatus((UpdateServerStatusCommand)command);
        }
        if (command instanceof ForcePushCommand) {
            return this.doExecute0(((ForcePushCommand)command).delegate());
        }
        throw new UnsupportedOperationException(command.toString());
    }

    private CompletableFuture<Void> createProject(CreateProjectCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            boolean encrypt;
            byte[] wdek = c.wdek();
            boolean bl = encrypt = wdek != null;
            if (encrypt) {
                this.encryptionStorageManager.storeWdek(c.projectName(), "dogma", wdek);
            }
            try {
                this.projectManager.create(c.projectName(), c.timestamp(), c.author(), encrypt);
            }
            catch (Throwable t) {
                if (encrypt) {
                    try {
                        this.encryptionStorageManager.removeWdek(c.projectName(), "dogma");
                    }
                    catch (Throwable t2) {
                        logger.warn("Failed to remove the WDEK of {}/{}", new Object[]{c.projectName(), "dogma", t2});
                    }
                }
                Exceptions.throwUnsafely((Throwable)t);
            }
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> removeProject(RemoveProjectCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            this.projectManager.remove(c.projectName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> unremoveProject(UnremoveProjectCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            this.projectManager.unremove(c.projectName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> purgeProject(PurgeProjectCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            this.projectManager.markForPurge(c.projectName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> resetMetaRepository(ResetMetaRepositoryCommand command) {
        return CompletableFuture.supplyAsync(() -> {
            Project project = (Project)this.projectManager.get(command.projectName());
            if (project == null) {
                throw new IllegalStateException("Project not found: " + command.projectName());
            }
            MetaRepository metaRepository = project.resetMetaRepository();
            if (!"dogma".equals(metaRepository.name())) {
                logger.warn("Meta repository name is not changed in {}. meta repo: {}", (Object)project.name(), (Object)metaRepository.name());
            }
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> createRepository(CreateRepositoryCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            boolean encrypt;
            byte[] wdek = c.wdek();
            boolean bl = encrypt = wdek != null;
            if (encrypt) {
                this.encryptionStorageManager.storeWdek(c.projectName(), c.repositoryName(), wdek);
            }
            try {
                ((Project)this.projectManager.get(c.projectName())).repos().create(c.repositoryName(), c.timestamp(), c.author(), encrypt);
            }
            catch (Throwable t) {
                if (encrypt) {
                    try {
                        this.encryptionStorageManager.removeWdek(c.projectName(), c.repositoryName());
                    }
                    catch (Throwable t2) {
                        logger.warn("Failed to remove the WDEK of {}/{}", new Object[]{c.projectName(), c.repositoryName(), t2});
                    }
                }
                Exceptions.throwUnsafely((Throwable)t);
            }
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> removeRepository(RemoveRepositoryCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            ((Project)this.projectManager.get(c.projectName())).repos().remove(c.repositoryName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> unremoveRepository(UnremoveRepositoryCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            ((Project)this.projectManager.get(c.projectName())).repos().unremove(c.repositoryName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> purgeRepository(PurgeRepositoryCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            ((Project)this.projectManager.get(c.projectName())).repos().markForPurge(c.repositoryName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> migrateToEncryptedRepository(MigrateToEncryptedRepositoryCommand c) {
        RepositoryManager repositoryManager = ((Project)this.projectManager.get(c.projectName())).repos();
        Repository repository = (Repository)repositoryManager.get(c.repositoryName());
        if (repository.isEncrypted()) {
            throw new IllegalStateException("The repository is already encrypted: " + c.projectName() + '/' + c.repositoryName());
        }
        return CompletableFuture.supplyAsync(() -> {
            this.encryptionStorageManager.storeWdek(c.projectName(), c.repositoryName(), c.wdek());
            try {
                repositoryManager.migrateToEncryptedRepository(c.repositoryName());
            }
            catch (Throwable t) {
                try {
                    this.encryptionStorageManager.removeWdek(c.projectName(), c.repositoryName());
                }
                catch (Throwable t2) {
                    logger.warn("Failed to remove the WDEK of {}/{}", new Object[]{c.projectName(), c.repositoryName(), t2});
                }
                throw t;
            }
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<CommitResult> push(RepositoryCommand<?> c, boolean normalizing) {
        if (c instanceof TransformCommand) {
            TransformCommand transformCommand = (TransformCommand)c;
            return this.repo(c).commit(transformCommand.baseRevision(), transformCommand.timestamp(), transformCommand.author(), transformCommand.summary(), transformCommand.detail(), transformCommand.markup(), transformCommand.transformer());
        }
        assert (c instanceof AbstractPushCommand);
        AbstractPushCommand pushCommand = (AbstractPushCommand)c;
        return this.repo(c).commit(pushCommand.baseRevision(), pushCommand.timestamp(), pushCommand.author(), pushCommand.summary(), pushCommand.detail(), pushCommand.markup(), pushCommand.changes(), normalizing);
    }

    private Repository repo(RepositoryCommand<?> c) {
        return (Repository)((Project)this.projectManager.get(c.projectName())).repos().get(c.repositoryName());
    }

    private CompletableFuture<Void> createSession(CreateSessionCommand c) {
        if (this.sessionManager == null) {
            return CompletableFuture.completedFuture(null);
        }
        Session session = c.session();
        return this.sessionManager.create(session).exceptionally(cause -> {
            logger.warn("Failed to replicate a session creation: {}", (Object)session, cause);
            return null;
        });
    }

    private CompletableFuture<Void> removeSession(RemoveSessionCommand c) {
        if (this.sessionManager == null) {
            return CompletableFuture.completedFuture(null);
        }
        String sessionId = c.sessionId();
        return this.sessionManager.delete(sessionId).exceptionally(cause -> {
            logger.warn("Failed to replicate a session removal: {}", (Object)sessionId, cause);
            return null;
        });
    }

    private CompletableFuture<Void> updateServerStatus(UpdateServerStatusCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            this.serverStatusManager.updateStatus(c.serverStatus());
            this.statusManager().updateStatus(c);
            return null;
        }, this.serverStatusManager.sequentialExecutor());
    }
}

