/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.command;

import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.command.UpdateServerStatusCommand;
import com.linecorp.centraldogma.server.management.ServerStatus;
import com.linecorp.centraldogma.server.management.ServerStatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommandExecutorStatusManager {
    private static final Logger logger = LoggerFactory.getLogger(ServerStatusManager.class);
    private final CommandExecutor executor;

    public CommandExecutorStatusManager(CommandExecutor executor) {
        this.executor = executor;
    }

    public CommandExecutor executor() {
        return this.executor;
    }

    public boolean writable() {
        return this.executor.isWritable();
    }

    public boolean replicating() {
        return this.executor.isStarted();
    }

    public synchronized void updateStatus(UpdateServerStatusCommand command) {
        ServerStatus serverStatus = command.serverStatus();
        this.updateStatus(serverStatus);
    }

    public synchronized void updateStatus(ServerStatus serverStatus) {
        if (serverStatus.replicating()) {
            this.setReplicating(serverStatus.replicating());
            this.setWritable(serverStatus.writable());
        } else {
            this.setWritable(serverStatus.writable());
            this.setReplicating(serverStatus.replicating());
        }
    }

    public synchronized boolean setWritable(boolean newWritable) {
        boolean writable = this.writable();
        if (writable == newWritable) {
            return true;
        }
        this.executor.setWritable(newWritable);
        if (newWritable) {
            logger.warn("Left read-only mode.");
        } else {
            logger.warn("Entered read-only mode. replication: {}", (Object)this.replicating());
        }
        return true;
    }

    public synchronized boolean setReplicating(boolean newReplicating) {
        if (newReplicating) {
            if (this.replicating()) {
                return true;
            }
            try {
                logger.info("Enabling replication ...");
                this.executor.start().get();
                logger.info("Enabled replication. read-only: {}", (Object)(!this.writable() ? 1 : 0));
                return true;
            }
            catch (Exception cause) {
                logger.warn("Failed to start the command executor:", (Throwable)cause);
                return false;
            }
        }
        if (!this.replicating()) {
            return true;
        }
        try {
            logger.info("Disabling replication ...");
            this.executor.stop().get();
            logger.info("Disabled replication");
            return true;
        }
        catch (Exception cause) {
            logger.warn("Failed to stop the command executor:", (Throwable)cause);
            return false;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("isWritable", this.writable()).add("replicating", this.replicating()).toString();
    }
}

