/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.MustBeClosed;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.io.ByteStreams;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.annotation.Nullable;

public final class TlsConfig {
    @Nullable
    private final File keyCertChainFile;
    @Nullable
    private final File keyFile;
    @Nullable
    private final String keyCertChain;
    @Nullable
    private final String key;
    @Nullable
    private final String keyPassword;

    @JsonCreator
    public TlsConfig(@JsonProperty(value="keyCertChainFile") @Nullable File keyCertChainFile, @JsonProperty(value="keyFile") @Nullable File keyFile, @JsonProperty(value="keyCertChain") @Nullable String keyCertChain, @JsonProperty(value="key") @Nullable String key, @JsonProperty(value="keyPassword") @Nullable String keyPassword) {
        TlsConfig.validate(keyCertChainFile, keyCertChain, "keyCertChainFile", "keyCertChain");
        TlsConfig.validate(keyFile, key, "keyFile", "key");
        this.keyCertChainFile = keyCertChainFile;
        this.keyFile = keyFile;
        this.keyCertChain = keyCertChain;
        this.key = key;
        this.keyPassword = keyPassword;
    }

    private static void validate(@Nullable File fileName, @Nullable String name, String first, String second) {
        Preconditions.checkArgument((fileName != null || name != null ? 1 : 0) != 0, (String)"%s and %s cannot be null at the same time.", (Object)first, (Object)second);
        if (fileName != null && name != null) {
            throw new IllegalArgumentException(String.format("%s and %s cannot be specified at the same time.", first, second));
        }
    }

    @Nullable
    @JsonProperty
    @Deprecated
    public File keyCertChainFile() {
        return this.keyCertChainFile;
    }

    @Nullable
    @JsonProperty
    @Deprecated
    public File keyFile() {
        return this.keyFile;
    }

    @MustBeClosed
    public InputStream keyCertChainInputStream() {
        return TlsConfig.inputStream(this.keyCertChainFile, this.keyCertChain, "keyCertChain");
    }

    @MustBeClosed
    public InputStream keyInputStream() {
        return TlsConfig.inputStream(this.keyFile, this.key, "key");
    }

    private static InputStream inputStream(@Nullable File file, @Nullable String property, String propertyName) {
        if (file != null) {
            ByteArrayInputStream byteArrayInputStream;
            block11: {
                InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
                try {
                    byteArrayInputStream = new ByteArrayInputStream(ByteStreams.toByteArray((InputStream)inputStream));
                    if (inputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("failed to create an input stream from " + file, e);
                    }
                }
                inputStream.close();
            }
            return byteArrayInputStream;
        }
        assert (property != null);
        String converted = CentralDogmaConfig.convertValue(property, "tls." + propertyName);
        if (converted == null) {
            throw new NullPointerException(propertyName + '(' + property + ") is converted to null.");
        }
        return new ByteArrayInputStream(converted.getBytes());
    }

    @JsonProperty
    @Nullable
    public String keyPassword() {
        return CentralDogmaConfig.convertValue(this.keyPassword, "tls.keyPassword");
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("keyCertChainFile", (Object)this.keyCertChainFile).add("keyFile", (Object)this.keyFile).toString();
    }
}

