/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.storage.repository;

import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.server.storage.repository.RepositoryUtil;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public interface RepositoryListener {
    public static RepositoryListener of(final String pathPattern, final Consumer<? super Map<String, Entry<?>>> listener) {
        Objects.requireNonNull(pathPattern, "pathPattern");
        Objects.requireNonNull(listener, "listener");
        return new RepositoryListener(){

            @Override
            public String pathPattern() {
                return pathPattern;
            }

            @Override
            public void onUpdate(Map<String, Entry<?>> entries) {
                listener.accept(entries);
            }
        };
    }

    public static <T> RepositoryListener of(final Query<T> query, final Consumer<? super Entry<T>> listener) {
        Objects.requireNonNull(query, "query");
        Objects.requireNonNull(listener, "listener");
        return new RepositoryListener(){

            @Override
            public String pathPattern() {
                return query.path();
            }

            @Override
            public void onUpdate(Map<String, Entry<?>> entries) {
                Entry<?> entry = entries.get(query.path());
                if (entry == null) {
                    listener.accept(null);
                } else {
                    entry = RepositoryUtil.applyQuery(entry, query);
                    listener.accept(entry);
                }
            }
        };
    }

    public String pathPattern();

    public void onUpdate(Map<String, Entry<?>> var1);
}

