/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.server.internal.storage.DirectoryBasedStorageManager;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryCache;
import com.linecorp.centraldogma.server.internal.storage.repository.git.GitRepository;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import com.linecorp.centraldogma.server.storage.repository.RepositoryManager;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class GitRepositoryManager
extends DirectoryBasedStorageManager<Repository>
implements RepositoryManager {
    private final Project parent;
    private final Executor repositoryWorker;
    @Nullable
    private final RepositoryCache cache;

    public GitRepositoryManager(Project parent, File rootDir, Executor repositoryWorker, Executor purgeWorker, @Nullable RepositoryCache cache) {
        super(rootDir, Repository.class, purgeWorker);
        this.parent = Objects.requireNonNull(parent, "parent");
        this.repositoryWorker = Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        this.cache = cache;
        this.init();
    }

    @Override
    public Project parent() {
        return this.parent;
    }

    @Override
    protected Repository openChild(File childDir) throws Exception {
        return new GitRepository(this.parent, childDir, this.repositoryWorker, this.cache);
    }

    @Override
    protected Repository createChild(File childDir, Author author, long creationTimeMillis) throws Exception {
        return new GitRepository(this.parent, childDir, this.repositoryWorker, creationTimeMillis, author, this.cache);
    }

    @Override
    protected void closeChild(File childDir, Repository child, Supplier<CentralDogmaException> failureCauseSupplier) {
        ((GitRepository)child).close(failureCauseSupplier);
    }

    @Override
    protected CentralDogmaException newStorageExistsException(String name) {
        return new RepositoryExistsException(this.parent().name() + '/' + name);
    }

    @Override
    protected CentralDogmaException newStorageNotFoundException(String name) {
        return new RepositoryNotFoundException(this.parent().name() + '/' + name);
    }
}

