/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.cache;

import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.MergeQuery;
import com.linecorp.centraldogma.common.MergedEntry;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.RevisionRange;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.command.ContentTransformer;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryCache;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableFindCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableFindLatestRevCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableHistoryCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableMergeQueryCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableMultiDiffCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableSingleDiffCall;
import com.linecorp.centraldogma.server.internal.storage.repository.git.PathPatternFilter;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.repository.CacheableCall;
import com.linecorp.centraldogma.server.storage.repository.DiffResultType;
import com.linecorp.centraldogma.server.storage.repository.FindOption;
import com.linecorp.centraldogma.server.storage.repository.FindOptions;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import com.linecorp.centraldogma.server.storage.repository.RepositoryListener;
import io.netty.channel.EventLoopGroup;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class CachingRepository
implements Repository {
    private static final CancellationException CANCELLATION_EXCEPTION = (CancellationException)Exceptions.clearTrace((Throwable)new CancellationException("watch cancelled by caller"));
    private final Repository repo;
    private final RepositoryCache cache;

    CachingRepository(Repository repo, RepositoryCache cache) {
        this.repo = Objects.requireNonNull(repo, "repo");
        this.cache = Objects.requireNonNull(cache, "cache");
    }

    @Override
    public org.eclipse.jgit.lib.Repository jGitRepository() {
        return this.repo.jGitRepository();
    }

    @Override
    public long creationTimeMillis() {
        return this.repo.creationTimeMillis();
    }

    @Override
    public Author author() {
        return this.repo.author();
    }

    @Override
    public CompletableFuture<Entry<?>> getOrNull(Revision revision, String path) {
        Objects.requireNonNull(revision, "revision");
        Objects.requireNonNull(path, "path");
        Revision normalizedRevision = this.normalizeNow(revision);
        return this.find(normalizedRevision, "/**", FindOptions.FIND_ALL_WITH_CONTENT).thenApply(all -> (Entry)all.get(path));
    }

    @Override
    public CompletableFuture<Map<String, Entry<?>>> find(Revision revision, String pathPattern, Map<FindOption<?>, ?> options) {
        Objects.requireNonNull(revision, "revision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        Objects.requireNonNull(options, "options");
        Revision normalizedRevision = this.normalizeNow(revision);
        ImmutableMap cacheableOptions = options;
        Integer maxEntries = (Integer)options.get(FindOption.MAX_ENTRIES);
        if (maxEntries != null) {
            ImmutableMap.Builder newOptions = ImmutableMap.builder();
            options.forEach((key, value) -> {
                if (key != FindOption.MAX_ENTRIES) {
                    newOptions.put(key, value);
                }
            });
            cacheableOptions = newOptions.build();
        }
        return this.execute(new CacheableFindCall(this.repo, normalizedRevision, "/**", (Map<FindOption<?>, ?>)cacheableOptions)).thenApply(all -> {
            if (all.isEmpty()) {
                return all;
            }
            Stream<Object> stream = all.entrySet().stream();
            if (!pathPattern.equals("/**")) {
                PathPatternFilter filter = PathPatternFilter.of(pathPattern);
                stream = stream.filter(entry -> filter.matches((String)entry.getKey()));
            }
            if (maxEntries != null) {
                stream = stream.limit(maxEntries.intValue());
            }
            return stream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldV, newV) -> oldV, LinkedHashMap::new));
        });
    }

    @Override
    public CompletableFuture<List<Commit>> history(Revision from, Revision to, String pathPattern, int maxCommits) {
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(pathPattern, "pathPattern");
        if (maxCommits <= 0) {
            throw new IllegalArgumentException("maxCommits: " + maxCommits + " (expected: > 0)");
        }
        RevisionRange range = this.normalizeNow(from, to);
        int actualMaxCommits = Math.min(maxCommits, Math.abs(range.from().major() - range.to().major()) + 1);
        return this.execute(new CacheableHistoryCall(this.repo, range.from(), range.to(), pathPattern, actualMaxCommits));
    }

    @Override
    public CompletableFuture<Change<?>> diff(Revision from, Revision to, Query<?> query) {
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(query, "query");
        RevisionRange range = this.normalizeNow(from, to).toAscending();
        return this.execute(new CacheableSingleDiffCall(this.repo, range.from(), range.to(), query));
    }

    @Override
    public CompletableFuture<Map<String, Change<?>>> diff(Revision from, Revision to, String pathPattern, DiffResultType diffResultType) {
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(pathPattern, "pathPattern");
        Objects.requireNonNull(diffResultType, "diffResultType");
        RevisionRange range = this.normalizeNow(from, to).toAscending();
        return this.execute(new CacheableMultiDiffCall(this.repo, range.from(), range.to(), pathPattern, diffResultType));
    }

    @Override
    public CompletableFuture<Revision> findLatestRevision(Revision lastKnownRevision, String pathPattern, boolean errorOnEntryNotFound) {
        Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        RevisionRange range = this.normalizeNow(lastKnownRevision, Revision.HEAD);
        if (range.from().equals((Object)range.to())) {
            return CompletableFuture.completedFuture(null);
        }
        return this.cache.get(new CacheableFindLatestRevCall(this.repo, range.from(), range.to(), pathPattern, errorOnEntryNotFound)).handleAsync((result, cause) -> {
            HttpApiUtil.throwUnsafelyIfNonNull(cause);
            if (result == CacheableFindLatestRevCall.ENTRY_NOT_FOUND) {
                throw new EntryNotFoundException(range.from(), pathPattern);
            }
            if (result == CacheableFindLatestRevCall.EMPTY) {
                return null;
            }
            return result;
        }, CachingRepository.executor());
    }

    @Override
    public CompletableFuture<Revision> watch(Revision lastKnownRevision, String pathPattern, boolean errorOnEntryNotFound) {
        Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        CompletableFuture<Revision> latestRevFuture = this.findLatestRevision(lastKnownRevision, pathPattern, errorOnEntryNotFound);
        if (latestRevFuture.isCompletedExceptionally() || latestRevFuture.getNow(null) != null) {
            return latestRevFuture;
        }
        CompletableFuture<Revision> future = new CompletableFuture<Revision>();
        latestRevFuture.whenComplete((latestRevision, cause) -> {
            if (cause != null) {
                future.completeExceptionally((Throwable)cause);
                return;
            }
            if (latestRevision != null) {
                future.complete((Revision)latestRevision);
                return;
            }
            CompletableFuture<Revision> watchFuture = this.repo.watch(lastKnownRevision, pathPattern, errorOnEntryNotFound);
            watchFuture.whenComplete((watchResult, watchCause) -> {
                if (watchCause == null) {
                    future.complete((Revision)watchResult);
                } else {
                    future.completeExceptionally((Throwable)watchCause);
                }
            });
            future.whenComplete((unused1, unused2) -> watchFuture.completeExceptionally(CANCELLATION_EXCEPTION));
        });
        return future;
    }

    @Override
    public <T> CompletableFuture<MergedEntry<T>> mergeFiles(Revision revision, MergeQuery<T> query) {
        Objects.requireNonNull(revision, "revision");
        Objects.requireNonNull(query, "query");
        Revision normalizedRevision = this.normalizeNow(revision);
        return this.execute(new CacheableMergeQueryCall<T>(this.repo, normalizedRevision, query));
    }

    @Override
    public <T> CompletableFuture<T> execute(CacheableCall<T> cacheableCall) {
        return (CompletableFuture)Util.unsafeCast((Object)this.cache.get(cacheableCall).handleAsync((result, cause) -> {
            HttpApiUtil.throwUnsafelyIfNonNull(cause);
            return result;
        }, CachingRepository.executor()));
    }

    @Override
    public void addListener(RepositoryListener listener) {
        this.repo.addListener(listener);
    }

    private static Executor executor() {
        return (Executor)RequestContext.mapCurrent(RequestContext::eventLoop, () -> ((EventLoopGroup)CommonPools.workerGroup()).next());
    }

    @Override
    public Project parent() {
        return this.repo.parent();
    }

    @Override
    public String name() {
        return this.repo.name();
    }

    @Override
    public Revision normalizeNow(Revision revision) {
        return this.repo.normalizeNow(revision);
    }

    @Override
    public RevisionRange normalizeNow(Revision from, Revision to) {
        return this.repo.normalizeNow(from, to);
    }

    @Override
    public CompletableFuture<Map<String, Change<?>>> previewDiff(Revision baseRevision, Iterable<Change<?>> changes) {
        Objects.requireNonNull(baseRevision, "baseRevision");
        return this.repo.previewDiff(baseRevision, changes);
    }

    @Override
    public CompletableFuture<CommitResult> commit(Revision baseRevision, long commitTimeMillis, Author author, String summary, String detail, Markup markup, Iterable<Change<?>> changes, boolean normalizing) {
        return this.repo.commit(baseRevision, commitTimeMillis, author, summary, detail, markup, changes, normalizing);
    }

    @Override
    public CompletableFuture<CommitResult> commit(Revision baseRevision, long commitTimeMillis, Author author, String summary, String detail, Markup markup, ContentTransformer<?> transformer) {
        return this.repo.commit(baseRevision, commitTimeMillis, author, summary, detail, markup, transformer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("repo", (Object)this.repo).toString();
    }
}

