/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.linecorp.centraldogma.common.MirrorException;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.FutureCallback;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.Futures;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.ListenableFuture;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.ListenableScheduledFuture;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.ListeningExecutorService;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.ListeningScheduledExecutorService;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.MoreExecutors;
import com.linecorp.centraldogma.server.MirroringService;
import com.linecorp.centraldogma.server.ZoneConfig;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.ExecutorServiceUtil;
import com.linecorp.centraldogma.server.internal.mirror.CompositeMirrorListener;
import com.linecorp.centraldogma.server.internal.mirror.DefaultMirrorListener;
import com.linecorp.centraldogma.server.internal.mirror.DefaultMirroringServicePlugin;
import com.linecorp.centraldogma.server.internal.mirror.InstrumentedMirroringJob;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.mirror.Mirror;
import com.linecorp.centraldogma.server.mirror.MirrorAccessController;
import com.linecorp.centraldogma.server.mirror.MirrorListener;
import com.linecorp.centraldogma.server.mirror.MirrorResult;
import com.linecorp.centraldogma.server.mirror.MirrorTask;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MirrorSchedulingService
implements MirroringService {
    private static final Logger logger = LoggerFactory.getLogger(MirrorSchedulingService.class);
    private static final MirrorListener mirrorListener;
    private static final Duration TICK;
    private final File workDir;
    private final ProjectManager projectManager;
    private final int numThreads;
    private final int maxNumFilesPerMirror;
    private final long maxNumBytesPerMirror;
    @Nullable
    private final ZoneConfig zoneConfig;
    @Nullable
    private final String currentZone;
    private final MirrorAccessController mirrorAccessController;
    private final AtomicInteger numActiveMirrors = new AtomicInteger();
    private volatile CommandExecutor commandExecutor;
    private volatile ListeningScheduledExecutorService scheduler;
    private volatile ListeningExecutorService worker;
    private volatile boolean closing;
    private ZonedDateTime lastExecutionTime;
    private final MeterRegistry meterRegistry;
    private final boolean runMigration;

    public static MirrorListener mirrorListener() {
        return mirrorListener;
    }

    @VisibleForTesting
    public MirrorSchedulingService(File workDir, ProjectManager projectManager, MeterRegistry meterRegistry, int numThreads, int maxNumFilesPerMirror, long maxNumBytesPerMirror, @Nullable ZoneConfig zoneConfig, boolean runMigration, MirrorAccessController mirrorAccessController) {
        this.workDir = Objects.requireNonNull(workDir, "workDir");
        this.projectManager = Objects.requireNonNull(projectManager, "projectManager");
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
        this.runMigration = runMigration;
        Preconditions.checkArgument((numThreads > 0 ? 1 : 0) != 0, (String)"numThreads: %s (expected: > 0)", (int)numThreads);
        Preconditions.checkArgument((maxNumFilesPerMirror > 0 ? 1 : 0) != 0, (String)"maxNumFilesPerMirror: %s (expected: > 0)", (int)maxNumFilesPerMirror);
        Preconditions.checkArgument((maxNumBytesPerMirror > 0L ? 1 : 0) != 0, (String)"maxNumBytesPerMirror: %s (expected: > 0)", (long)maxNumBytesPerMirror);
        this.numThreads = numThreads;
        this.maxNumFilesPerMirror = maxNumFilesPerMirror;
        this.maxNumBytesPerMirror = maxNumBytesPerMirror;
        this.zoneConfig = zoneConfig;
        this.currentZone = zoneConfig != null ? zoneConfig.currentZone() : null;
        this.mirrorAccessController = mirrorAccessController;
    }

    public boolean isStarted() {
        return this.scheduler != null;
    }

    public synchronized void start(CommandExecutor commandExecutor) {
        if (this.isStarted()) {
            return;
        }
        this.commandExecutor = Objects.requireNonNull(commandExecutor, "commandExecutor");
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("mirroring-scheduler", true));
        executorService = ExecutorServiceMetrics.monitor((MeterRegistry)this.meterRegistry, (ScheduledExecutorService)executorService, (String)"mirroringScheduler", (Tag[])new Tag[0]);
        this.scheduler = MoreExecutors.listeningDecorator((ScheduledExecutorService)executorService);
        SynchronousQueue<Runnable> workQueue = new SynchronousQueue<Runnable>();
        this.worker = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(0, this.numThreads, 90L, TimeUnit.SECONDS, workQueue, (ThreadFactory)new DefaultThreadFactory("mirroring-worker", true), (rejectedTask, executor) -> {
            try {
                workQueue.put(rejectedTask);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }));
        ListenableScheduledFuture future = this.scheduler.scheduleWithFixedDelay(this::scheduleMirrors, TICK.getSeconds(), TICK.getSeconds(), TimeUnit.SECONDS);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(@Nullable Object result) {
            }

            public void onFailure(Throwable cause) {
                logger.error("Git mirroring scheduler stopped due to an unexpected exception:", cause);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        this.closing = true;
        int numActiveMirrors = this.numActiveMirrors.get();
        if (numActiveMirrors > 0) {
            logger.info("Waiting for {} active mirrors to finish up to 10 seconds...", (Object)numActiveMirrors);
            for (int i = 0; i < 10; ++i) {
                try {
                    if (this.numActiveMirrors.get() == 0) break;
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        ListeningScheduledExecutorService scheduler = this.scheduler;
        ListeningExecutorService worker = this.worker;
        try {
            boolean interrupted;
            boolean bl = interrupted = ExecutorServiceUtil.terminate((ExecutorService)scheduler) || ExecutorServiceUtil.terminate((ExecutorService)worker);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            this.scheduler = null;
            this.worker = null;
        }
    }

    private void scheduleMirrors() {
        if (this.closing) {
            return;
        }
        ZonedDateTime now = ZonedDateTime.now();
        if (this.lastExecutionTime == null) {
            this.lastExecutionTime = now.minus(TICK);
        }
        ZonedDateTime currentLastExecutionTime = this.lastExecutionTime;
        this.lastExecutionTime = now;
        this.projectManager.list().values().forEach(project -> {
            List<Mirror> mirrors;
            if (this.closing) {
                return;
            }
            if ("dogma".equals(project.name())) {
                return;
            }
            try {
                mirrors = project.metaRepo().mirrors().get(5L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                logger.warn("Failed to load the mirror list within 5 seconds. project: {}", (Object)project.name(), (Object)e);
                return;
            }
            catch (Exception e) {
                logger.warn("Failed to load the mirror list from: {}", (Object)project.name(), (Object)e);
                return;
            }
            for (Mirror m : mirrors) {
                block14: {
                    if (m.schedule() == null) continue;
                    try {
                        boolean allowed = this.mirrorAccessController.isAllowed(m).get(5L, TimeUnit.SECONDS);
                        if (!allowed) {
                            mirrorListener.onDisallowed(m);
                        }
                        break block14;
                    }
                    catch (Exception e) {
                        logger.warn("Failed to check the access control. mirror: {}", (Object)m, (Object)e);
                    }
                    continue;
                }
                if (this.zoneConfig != null) {
                    String pinnedZone = m.zone();
                    if (pinnedZone == null) {
                        pinnedZone = this.zoneConfig.allZones().get(0);
                    }
                    if (!pinnedZone.equals(this.currentZone)) {
                        if (this.zoneConfig.allZones().contains(pinnedZone)) continue;
                        MirrorTask invalidMirror = new MirrorTask(m, User.SYSTEM, Instant.now(), pinnedZone, true);
                        mirrorListener.onStart(invalidMirror);
                        mirrorListener.onError(invalidMirror, new MirrorException("The mirror is pinned to an unknown zone: " + pinnedZone + " (valid zones: " + this.zoneConfig.allZones() + ')'));
                        continue;
                    }
                }
                try {
                    if (m.nextExecutionTime(currentLastExecutionTime).compareTo(now) >= 0) continue;
                    this.runAsync(new MirrorTask(m, User.SYSTEM, Instant.now(), this.currentZone, true));
                }
                catch (Exception e) {
                    logger.warn("Unexpected exception while mirroring: {}", (Object)m, (Object)e);
                }
            }
        });
    }

    @Override
    public CompletableFuture<Void> mirror() {
        if (this.commandExecutor == null) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.runAsync(() -> this.projectManager.list().values().forEach(p -> {
            if ("dogma".equals(p.name())) {
                return;
            }
            try {
                p.metaRepo().mirrors().get(5L, TimeUnit.SECONDS).forEach(m -> this.run(new MirrorTask((Mirror)m, User.SYSTEM, Instant.now(), this.currentZone, false)));
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new IllegalStateException("Failed to load mirror list with in 5 seconds. project: " + p.name(), e);
            }
        }), (Executor)this.worker);
    }

    private void runAsync(MirrorTask m) {
        this.worker.submit(() -> this.run(m));
    }

    private void run(MirrorTask mirrorTask) {
        this.numActiveMirrors.incrementAndGet();
        if (this.closing) {
            this.numActiveMirrors.decrementAndGet();
            return;
        }
        try {
            mirrorListener.onStart(mirrorTask);
            MirrorResult result = new InstrumentedMirroringJob(mirrorTask, this.meterRegistry).run(this.workDir, this.commandExecutor, this.maxNumFilesPerMirror, this.maxNumBytesPerMirror);
            mirrorListener.onComplete(mirrorTask, result);
        }
        catch (Exception e) {
            mirrorListener.onError(mirrorTask, e);
            if (!mirrorTask.scheduled()) {
                if (e instanceof MirrorException) {
                    throw (MirrorException)((Object)e);
                }
                throw new MirrorException((Throwable)e);
            }
        }
        finally {
            this.numActiveMirrors.decrementAndGet();
        }
    }

    static {
        ImmutableList listeners = ImmutableList.copyOf(ServiceLoader.load(MirrorListener.class, DefaultMirroringServicePlugin.class.getClassLoader()));
        mirrorListener = listeners.isEmpty() ? DefaultMirrorListener.INSTANCE : new CompositeMirrorListener((List<MirrorListener>)listeners);
        TICK = Duration.ofSeconds(1L);
    }
}

