/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Iterables;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpApiResponseConverter
implements ResponseConverterFunction {
    private static final Logger logger = LoggerFactory.getLogger(HttpApiResponseConverter.class);

    public HttpResponse convertResponse(ServiceRequestContext ctx, ResponseHeaders headers, @Nullable Object resObj, HttpHeaders trailingHeaders) throws Exception {
        try {
            ResponseHeaders resHeaders;
            HttpRequest request = RequestContext.current().request();
            if (resObj == null || HttpMethod.DELETE == request.method() || resObj instanceof Iterable && Iterables.size((Iterable)((Iterable)resObj)) == 0) {
                return HttpResponse.of((HttpStatus)HttpStatus.NO_CONTENT);
            }
            if (headers.contentType() == null) {
                ResponseHeadersBuilder builder = headers.toBuilder();
                builder.contentType(MediaType.JSON_UTF_8);
                resHeaders = builder.build();
            } else {
                resHeaders = headers;
            }
            HttpData httpData = HttpData.wrap((byte[])Jackson.writeValueAsBytes((Object)resObj));
            return HttpResponse.of((ResponseHeaders)resHeaders, (HttpData)httpData, (HttpHeaders)trailingHeaders);
        }
        catch (JsonProcessingException e) {
            logger.debug("Failed to convert a response:", (Throwable)e);
            return HttpApiUtil.newResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, e);
        }
    }
}

