/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.auth;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.annotation.DecoratorFactoryFunction;
import com.linecorp.centraldogma.common.ProjectNotFoundException;
import com.linecorp.centraldogma.common.ProjectRole;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresProjectRole;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import com.linecorp.centraldogma.server.metadata.User;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class RequiresProjectRoleDecorator
extends SimpleDecoratingHttpService {
    private final MetadataService mds;
    private final ProjectRole requiredRole;

    RequiresProjectRoleDecorator(HttpService delegate, MetadataService mds, ProjectRole requiredRole) {
        super(delegate);
        this.mds = Objects.requireNonNull(mds, "mds");
        this.requiredRole = Objects.requireNonNull(requiredRole, "requiredRole");
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        User user = AuthUtil.currentUser(ctx);
        String projectName = ctx.pathParam("projectName");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectName) ? 1 : 0) != 0, (Object)"no project name is specified");
        if (user.isSystemAdmin()) {
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
        }
        try {
            return HttpResponse.of((CompletableFuture)this.mds.findProjectRole(projectName, user).handle((role, cause) -> {
                if (cause != null) {
                    return RequiresProjectRoleDecorator.handleException(ctx, cause);
                }
                if (role == null || !role.has(this.requiredRole)) {
                    return (HttpResponse)HttpApiUtil.throwResponse(ctx, HttpStatus.FORBIDDEN, "You must have the %s project role to access the project '%s'.", this.requiredRole, projectName);
                }
                try {
                    return (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
                }
                catch (Exception e) {
                    return (HttpResponse)Exceptions.throwUnsafely((Throwable)e);
                }
            }));
        }
        catch (Throwable cause2) {
            return RequiresProjectRoleDecorator.handleException(ctx, cause2);
        }
    }

    static HttpResponse handleException(ServiceRequestContext ctx, Throwable cause) {
        if ((cause = Exceptions.peel((Throwable)cause)) instanceof RepositoryNotFoundException || cause instanceof ProjectNotFoundException) {
            return HttpApiUtil.newResponse(ctx, HttpStatus.NOT_FOUND, cause);
        }
        return (HttpResponse)Exceptions.throwUnsafely((Throwable)cause);
    }

    public static final class RequiresProjectRoleDecoratorFactory
    implements DecoratorFactoryFunction<RequiresProjectRole> {
        private final MetadataService mds;

        public RequiresProjectRoleDecoratorFactory(MetadataService mds) {
            this.mds = mds;
        }

        public Function<? super HttpService, ? extends HttpService> newDecorator(RequiresProjectRole parameter) {
            return delegate -> new RequiresProjectRoleDecorator((HttpService)delegate, this.mds, parameter.value());
        }
    }
}

