/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.linecorp.armeria.server.annotation.ConsumesJson;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.armeria.server.annotation.Put;
import com.linecorp.armeria.server.annotation.StatusCode;
import com.linecorp.armeria.server.annotation.decorator.RequestTimeout;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.ProjectRole;
import com.linecorp.centraldogma.common.RepositoryRole;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.api.v1.MirrorDto;
import com.linecorp.centraldogma.internal.api.v1.MirrorRequest;
import com.linecorp.centraldogma.internal.api.v1.PushResultDto;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.Cron;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.ZoneConfig;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresProjectRole;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresRepositoryRole;
import com.linecorp.centraldogma.server.internal.mirror.DefaultMirroringServicePlugin;
import com.linecorp.centraldogma.server.internal.mirror.MirrorRunner;
import com.linecorp.centraldogma.server.internal.mirror.MirrorSchedulingService;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectApiManager;
import com.linecorp.centraldogma.server.internal.storage.repository.DefaultMetaRepository;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.mirror.Mirror;
import com.linecorp.centraldogma.server.mirror.MirrorAccessController;
import com.linecorp.centraldogma.server.mirror.MirrorListener;
import com.linecorp.centraldogma.server.mirror.MirrorResult;
import com.linecorp.centraldogma.server.mirror.MirroringServicePluginConfig;
import com.linecorp.centraldogma.server.storage.repository.MetaRepository;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProducesJson
public class MirroringServiceV1
extends AbstractService {
    private static final Logger logger = LoggerFactory.getLogger(MirroringServiceV1.class);
    private final ProjectApiManager projectApiManager;
    private final MirrorRunner mirrorRunner;
    private final Map<String, Object> mirrorZoneConfig;
    @Nullable
    private final ZoneConfig zoneConfig;
    private final MirrorAccessController accessController;

    public MirroringServiceV1(ProjectApiManager projectApiManager, CommandExecutor executor, MirrorRunner mirrorRunner, CentralDogmaConfig config, MirrorAccessController accessController) {
        super(executor);
        this.projectApiManager = projectApiManager;
        this.mirrorRunner = mirrorRunner;
        this.zoneConfig = config.zone();
        this.mirrorZoneConfig = MirroringServiceV1.mirrorZoneConfig(config);
        this.accessController = accessController;
    }

    private static Map<String, Object> mirrorZoneConfig(CentralDogmaConfig config) {
        MirroringServicePluginConfig mirrorConfig = DefaultMirroringServicePlugin.mirrorConfig(config);
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)2);
        boolean zonePinned = mirrorConfig != null && mirrorConfig.zonePinned();
        builder.put((Object)"zonePinned", (Object)zonePinned);
        ZoneConfig zone = config.zone();
        if (zone != null) {
            builder.put((Object)"zone", (Object)zone);
        }
        return builder.build();
    }

    @RequiresProjectRole(value=ProjectRole.OWNER)
    @Get(value="/projects/{projectName}/mirrors")
    public CompletableFuture<List<MirrorDto>> listProjectMirrors(@Param String projectName) {
        CompletableFuture<List<Mirror>> future = this.metaRepo(projectName).mirrors(true);
        return this.convertToMirrorDtos(projectName, future);
    }

    @RequiresRepositoryRole(value=RepositoryRole.ADMIN)
    @Get(value="/projects/{projectName}/repos/{repoName}/mirrors")
    public CompletableFuture<List<MirrorDto>> listRepoMirrors(@Param String projectName, Repository repository) {
        CompletableFuture<List<Mirror>> future = this.metaRepo(projectName).mirrors(repository.name(), true);
        return this.convertToMirrorDtos(projectName, future);
    }

    @RequiresRepositoryRole(value=RepositoryRole.ADMIN)
    @Get(value="/projects/{projectName}/repos/{repoName}/mirrors/{id}")
    public CompletableFuture<MirrorDto> getMirror(@Param String projectName, Repository repository, @Param String id) {
        return this.metaRepo(projectName).mirror(repository.name(), id).thenCompose(mirror -> this.accessController.isAllowed(mirror.remoteRepoUri()).thenApply(allowed -> MirroringServiceV1.convertToMirrorDto(projectName, mirror, allowed)));
    }

    @Post(value="/projects/{projectName}/repos/{repoName}/mirrors")
    @ConsumesJson
    @StatusCode(value=201)
    @RequiresRepositoryRole(value=RepositoryRole.ADMIN)
    public CompletableFuture<PushResultDto> createMirror(@Param String projectName, Repository repository, MirrorRequest newMirror, Author author, User user) {
        return this.createOrUpdate(projectName, repository.name(), newMirror, author, user, false);
    }

    @ConsumesJson
    @Put(value="/projects/{projectName}/repos/{repoName}/mirrors/{id}")
    @RequiresRepositoryRole(value=RepositoryRole.ADMIN)
    public CompletableFuture<PushResultDto> updateMirror(@Param String projectName, Repository repository, MirrorRequest mirror, @Param String id, Author author, User user) {
        Preconditions.checkArgument((boolean)id.equals(mirror.id()), (String)"The mirror ID (%s) can't be updated", (Object)id);
        return this.createOrUpdate(projectName, repository.name(), mirror, author, user, true);
    }

    @Delete(value="/projects/{projectName}/repos/{repoName}/mirrors/{id}")
    @RequiresRepositoryRole(value=RepositoryRole.ADMIN)
    public CompletableFuture<Void> deleteMirror(@Param String projectName, Repository repository, @Param String id, Author author) {
        MetaRepository metaRepository = this.metaRepo(projectName);
        String repoName = repository.name();
        return metaRepository.mirror(repoName, id).thenCompose(mirror -> {
            Command<CommitResult> command = Command.push(author, projectName, metaRepository.name(), Revision.HEAD, "Delete mirror: " + id + " in " + repoName, "", Markup.PLAINTEXT, Change.ofRemoval((String)DefaultMetaRepository.mirrorFile(repoName, id)));
            return this.executor().execute(command).thenApply(result -> null);
        });
    }

    private CompletableFuture<PushResultDto> createOrUpdate(String projectName, String repoName, MirrorRequest newMirror, Author author, User user, boolean update) {
        MetaRepository metaRepo = this.metaRepo(projectName);
        return metaRepo.createMirrorPushCommand(repoName, newMirror, author, this.zoneConfig, update).thenCompose(command -> this.executor().execute(command).thenApply(result -> {
            metaRepo.mirror(repoName, newMirror.id(), result.revision()).handle((mirror, cause) -> {
                if (cause != null) {
                    logger.warn("Failed to get the mirror: {}", (Object)newMirror.id(), cause);
                    return null;
                }
                return this.notifyMirrorEvent((Mirror)mirror, user, update);
            });
            return new PushResultDto(result.revision(), command.timestamp());
        }));
    }

    private Void notifyMirrorEvent(Mirror mirror, User user, boolean update) {
        try {
            MirrorListener listener = MirrorSchedulingService.mirrorListener();
            if (update) {
                listener.onUpdate(mirror, user, this.accessController);
            } else {
                listener.onCreate(mirror, user, this.accessController);
            }
        }
        catch (Throwable ex) {
            logger.warn("Failed to notify the mirror listener. (mirror: {})", (Object)mirror, (Object)ex);
        }
        return null;
    }

    @RequestTimeout(value=5L, unit=TimeUnit.MINUTES)
    @Post(value="/projects/{projectName}/repos/{repoName}/mirrors/{mirrorId}/run")
    @RequiresRepositoryRole(value=RepositoryRole.ADMIN)
    public CompletableFuture<MirrorResult> runMirror(@Param String projectName, Repository repository, @Param String mirrorId, User user) throws Exception {
        return this.mirrorRunner.run(projectName, repository.name(), mirrorId, user);
    }

    @Get(value="/mirror/config")
    public Map<String, Object> config() {
        return this.mirrorZoneConfig;
    }

    private CompletableFuture<List<MirrorDto>> convertToMirrorDtos(String projectName, CompletableFuture<List<Mirror>> future) {
        return future.thenCompose(mirrors -> {
            ImmutableList remoteUris = (ImmutableList)mirrors.stream().map(mirror -> mirror.remoteRepoUri().toString()).collect(ImmutableList.toImmutableList());
            return this.accessController.isAllowed((Iterable<String>)remoteUris).thenApply(acl -> (List)mirrors.stream().map(mirror -> MirroringServiceV1.convertToMirrorDto(projectName, mirror, acl)).collect(ImmutableList.toImmutableList()));
        });
    }

    private static MirrorDto convertToMirrorDto(String projectName, Mirror mirror, Map<String, Boolean> acl) {
        boolean allowed = acl.get(mirror.remoteRepoUri().toString());
        return MirroringServiceV1.convertToMirrorDto(projectName, mirror, allowed);
    }

    private static MirrorDto convertToMirrorDto(String projectName, Mirror mirror, boolean allowed) {
        URI remoteRepoUri = mirror.remoteRepoUri();
        Cron schedule = mirror.schedule();
        String scheduleStr = schedule != null ? schedule.asString() : null;
        return new MirrorDto(mirror.id(), Boolean.valueOf(mirror.enabled()), projectName, scheduleStr, mirror.direction().name(), mirror.localRepo().name(), mirror.localPath(), remoteRepoUri.getScheme(), remoteRepoUri.getAuthority() + remoteRepoUri.getPath(), mirror.remotePath(), mirror.remoteBranch(), mirror.gitignore(), mirror.credential().name(), mirror.zone(), allowed);
    }

    private MetaRepository metaRepo(String projectName) {
        return this.projectApiManager.getProject(projectName).metaRepo();
    }
}

