/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.auth;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.auth.OAuth2Token;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.auth.AuthTokenExtractors;
import com.linecorp.armeria.server.auth.Authorizer;
import com.linecorp.centraldogma.server.auth.SessionManager;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.metadata.User;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class SessionTokenAuthorizer
implements Authorizer<HttpRequest> {
    private final SessionManager sessionManager;
    private final Set<String> systemAdministrators;

    public SessionTokenAuthorizer(SessionManager sessionManager, Set<String> systemAdministrators) {
        this.sessionManager = Objects.requireNonNull(sessionManager, "sessionManager");
        this.systemAdministrators = Objects.requireNonNull(systemAdministrators, "systemAdministrators");
    }

    public CompletionStage<Boolean> authorize(ServiceRequestContext ctx, HttpRequest data) {
        OAuth2Token token = (OAuth2Token)AuthTokenExtractors.oAuth2().apply(data.headers());
        if (token == null) {
            return CompletableFuture.completedFuture(false);
        }
        return this.sessionManager.get(token.accessToken()).thenApply(session -> {
            if (session == null) {
                return false;
            }
            String username = session.username();
            List<String> roles = this.systemAdministrators.contains(username) ? User.LEVEL_SYSTEM_ADMIN : User.LEVEL_USER;
            User user = new User(username, roles);
            ctx.logBuilder().authenticatedUser("user/" + username);
            AuthUtil.setCurrentUser(ctx, user);
            HttpApiUtil.setVerboseResponses(ctx, user);
            return true;
        });
    }
}

