/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import java.util.Objects;

public final class ManagementConfig {
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_PATH = "/internal/management";
    private final SessionProtocol protocol;
    @Nullable
    private final String address;
    private final int port;
    private final String path;

    @JsonCreator
    public ManagementConfig(@JsonProperty(value="protocol") @Nullable String protocol, @JsonProperty(value="address") @Nullable String address, @JsonProperty(value="port") int port, @JsonProperty(value="path") @Nullable String path) {
        this(SessionProtocol.of((String)((String)MoreObjects.firstNonNull((Object)protocol, (Object)DEFAULT_PROTOCOL))), address, port, path);
    }

    public ManagementConfig(@Nullable SessionProtocol protocol, @Nullable String address, int port, @Nullable String path) {
        protocol = (SessionProtocol)MoreObjects.firstNonNull((Object)protocol, (Object)SessionProtocol.HTTP);
        Preconditions.checkArgument((protocol != SessionProtocol.PROXY ? 1 : 0) != 0, (String)"protocol: %s (expected: one of %s)", (Object)protocol, (Object)SessionProtocol.httpAndHttpsValues());
        this.protocol = protocol;
        this.address = address;
        Preconditions.checkArgument((port >= 0 && port <= 65535 ? 1 : 0) != 0, (String)"management.port: %s (expected: 0-65535)", (int)port);
        this.port = port;
        this.path = (String)MoreObjects.firstNonNull((Object)path, (Object)DEFAULT_PATH);
    }

    @JsonProperty(value="protocol")
    public SessionProtocol protocol() {
        return this.protocol;
    }

    @JsonProperty(value="address")
    @Nullable
    public String address() {
        return this.address;
    }

    @JsonProperty(value="port")
    public int port() {
        return this.port;
    }

    @JsonProperty(value="path")
    public String path() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManagementConfig)) {
            return false;
        }
        ManagementConfig that = (ManagementConfig)o;
        return this.port == that.port && this.protocol == that.protocol && Objects.equals(this.address, that.address) && this.path.equals(that.path);
    }

    public int hashCode() {
        return Objects.hash(this.protocol, this.address, this.port, this.path);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("protocol", (Object)this.protocol).add("address", (Object)this.address).add("port", this.port).add("path", (Object)this.path).toString();
    }
}

