/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.storage.project;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.shaded.guava.base.Ascii;
import com.linecorp.centraldogma.server.metadata.ProjectMetadata;
import com.linecorp.centraldogma.server.storage.project.ProjectUtil;
import com.linecorp.centraldogma.server.storage.repository.MetaRepository;
import com.linecorp.centraldogma.server.storage.repository.RepositoryManager;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public interface Project {
    public static final String REPO_DOGMA = "dogma";
    public static final String REPO_META = "meta";

    public String name();

    public long creationTimeMillis();

    public Author author();

    public MetaRepository metaRepo();

    public RepositoryManager repos();

    @Nullable
    public ProjectMetadata metadata();

    public static List<String> internalRepos() {
        return ProjectUtil.internalRepos;
    }

    public static boolean isReservedRepoName(String repoName) {
        Objects.requireNonNull(repoName, "repoName");
        repoName = Ascii.toLowerCase((String)repoName);
        return Project.internalRepos().contains(repoName);
    }
}

