/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.metadata.Identifiable;
import com.linecorp.centraldogma.server.metadata.UserAndTimestamp;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class Token
implements Identifiable {
    private final String appId;
    @Nullable
    private final String secret;
    private final boolean isAdmin;
    private final UserAndTimestamp creation;
    @Nullable
    private final UserAndTimestamp deactivation;
    @Nullable
    private final UserAndTimestamp deletion;

    Token(String appId, String secret, boolean isAdmin, UserAndTimestamp creation) {
        this(appId, secret, isAdmin, isAdmin, creation, null, null);
    }

    @JsonCreator
    public Token(@JsonProperty(value="appId") String appId, @JsonProperty(value="secret") String secret, @JsonProperty(value="admin") @Nullable Boolean isAdmin, @JsonProperty(value="systemAdmin") @Nullable Boolean isSystemAdmin, @JsonProperty(value="creation") UserAndTimestamp creation, @JsonProperty(value="deactivation") @Nullable UserAndTimestamp deactivation, @JsonProperty(value="deletion") @Nullable UserAndTimestamp deletion) {
        assert (isAdmin != null || isSystemAdmin != null);
        this.appId = Util.validateFileName((String)appId, (String)"appId");
        this.secret = Util.validateFileName((String)secret, (String)"secret");
        this.isAdmin = isSystemAdmin != null ? isSystemAdmin : isAdmin;
        this.creation = Objects.requireNonNull(creation, "creation");
        this.deactivation = deactivation;
        this.deletion = deletion;
    }

    private Token(String appId, boolean isAdmin, UserAndTimestamp creation, @Nullable UserAndTimestamp deactivation, @Nullable UserAndTimestamp deletion) {
        this.appId = Util.validateFileName((String)appId, (String)"appId");
        this.isAdmin = isAdmin;
        this.creation = Objects.requireNonNull(creation, "creation");
        this.deactivation = deactivation;
        this.deletion = deletion;
        this.secret = null;
    }

    @Override
    public String id() {
        return this.appId;
    }

    @JsonProperty
    public String appId() {
        return this.appId;
    }

    @Nullable
    @JsonProperty
    public String secret() {
        return this.secret;
    }

    @JsonProperty
    public boolean isAdmin() {
        return this.isAdmin;
    }

    @JsonProperty
    public UserAndTimestamp creation() {
        return this.creation;
    }

    @Nullable
    @JsonProperty
    public UserAndTimestamp deactivation() {
        return this.deactivation;
    }

    @Nullable
    @JsonProperty
    public UserAndTimestamp deletion() {
        return this.deletion;
    }

    @JsonIgnore
    public boolean isActive() {
        return this.deactivation == null && this.deletion == null;
    }

    @JsonIgnore
    public boolean isDeleted() {
        return this.deletion != null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("appId", (Object)this.appId()).add("isAdmin", this.isAdmin()).add("creation", (Object)this.creation()).add("deactivation", (Object)this.deactivation()).add("deletion", (Object)this.deletion()).toString();
    }

    public Token withoutSecret() {
        return new Token(this.appId(), this.isAdmin(), this.creation(), this.deactivation(), this.deletion());
    }

    public Token withAdmin(boolean isAdmin) {
        if (isAdmin == this.isAdmin()) {
            return this;
        }
        String secret = this.secret();
        assert (secret != null);
        return new Token(this.appId(), secret, isAdmin, isAdmin, this.creation(), this.deactivation(), this.deletion());
    }
}

