/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Sets;
import com.linecorp.centraldogma.server.metadata.Permission;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class PerRolePermissions {
    public static final Collection<Permission> ALL_PERMISSION = EnumSet.allOf(Permission.class);
    public static final Collection<Permission> READ_WRITE = EnumSet.of(Permission.READ, Permission.WRITE);
    public static final Collection<Permission> READ_ONLY = EnumSet.of(Permission.READ);
    public static final Collection<Permission> NO_PERMISSION = EnumSet.noneOf(Permission.class);
    @Deprecated
    public static final PerRolePermissions DEFAULT = new PerRolePermissions(READ_WRITE, READ_WRITE, NO_PERMISSION, null);
    private static final PerRolePermissions internalPermissions = new PerRolePermissions(READ_WRITE, NO_PERMISSION, NO_PERMISSION, null);
    private final Set<Permission> owner;
    private final Set<Permission> member;
    private final Set<Permission> guest;

    public static PerRolePermissions ofInternal() {
        return internalPermissions;
    }

    public static PerRolePermissions ofDefault() {
        return DEFAULT;
    }

    public static PerRolePermissions ofPublic() {
        return new PerRolePermissions(READ_WRITE, READ_WRITE, READ_WRITE, null);
    }

    public static PerRolePermissions ofPrivate() {
        return new PerRolePermissions(READ_WRITE, READ_WRITE, NO_PERMISSION, null);
    }

    @JsonCreator
    public PerRolePermissions(@JsonProperty(value="owner") Iterable<Permission> owner, @JsonProperty(value="member") Iterable<Permission> member, @JsonProperty(value="guest") Iterable<Permission> guest, @JsonProperty(value="anonymous") @Nullable Iterable<Permission> unused) {
        this.owner = Sets.immutableEnumSet(Objects.requireNonNull(owner, "owner"));
        this.member = Sets.immutableEnumSet(Objects.requireNonNull(member, "member"));
        this.guest = Sets.immutableEnumSet(Objects.requireNonNull(guest, "guest"));
    }

    @JsonProperty
    public Set<Permission> owner() {
        return this.owner;
    }

    @JsonProperty
    public Set<Permission> member() {
        return this.member;
    }

    @JsonProperty
    public Set<Permission> guest() {
        return this.guest;
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.member, this.guest);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerRolePermissions that = (PerRolePermissions)o;
        return this.owner.equals(that.owner) && this.member.equals(that.member) && this.guest.equals(that.guest);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("owner", this.owner()).add("member", this.member()).add("guest", this.guest()).toString();
    }
}

